# 🚀 راهنمای نصب و راه‌اندازی سیستم MLM

## ⚡ نصب سریع (Ubuntu/Debian)

```bash
# 1. استخراج فایل
unzip amozeshi_final.zip
cd amozeshi_final

# 2. اجرای نصب خودکار
chmod +x install.sh
sudo ./install.sh

# 3. راه‌اندازی (بعد از نصب)
# Terminal 1 - Backend:
cd backend
source venv/bin/activate
python server.py

# Terminal 2 - Frontend:
cd frontend
yarn start
```

---

## 📋 پیش‌نیازها

سیستم به صورت خودکار موارد زیر را نصب می‌کند:
- ✅ Docker (برای MongoDB)
- ✅ Python 3.8+
- ✅ Node.js 16+
- ✅ Yarn
- ✅ MongoDB (در Docker)
- ✅ تمام کتابخانه‌های لازم

---

## 🔐 اطلاعات ورود

**Admin:**
- Email: `admin@mlm.com`
- Password: `admin123`

⚠️ **مهم:** حتماً بعد از اولین ورود، رمز عبور را تغییر دهید!

---

## 🌐 آدرس‌های دسترسی

- **Frontend:** `http://YOUR_SERVER_IP:3000`
- **Backend API:** `http://YOUR_SERVER_IP:8001`
- **API Docs:** `http://YOUR_SERVER_IP:8001/docs`
- **Health Check:** `http://YOUR_SERVER_IP:8001/api/health`

---

## 🧪 تست سیستم

### بررسی Backend:
```bash
curl http://localhost:8001/api/health
```

خروجی مورد انتظار:
```json
{
  "status": "ok",
  "mongodb": true,
  "seed_user": true
}
```

### بررسی MongoDB:
```bash
docker ps | grep mlm-mongodb
```

### بررسی Frontend:
مرورگر را باز کنید: `http://localhost:3000`

---

## 🛠️ مدیریت سرویس‌ها

### MongoDB:
```bash
# مشاهده وضعیت
docker ps | grep mlm-mongodb

# متوقف کردن
docker stop mlm-mongodb

# شروع
docker start mlm-mongodb

# لاگ‌ها
docker logs mlm-mongodb -f
```

### Backend:
```bash
# اجرا
cd backend
source venv/bin/activate
python server.py

# متوقف کردن: Ctrl+C
```

### Frontend:
```bash
# Development Mode:
cd frontend
yarn start

# Production Build:
yarn build
npx serve -s build -l 3000 --single
```

---

## 🔧 عیب‌یابی

### ❌ خطا: "Failed to connect to MongoDB"
**علت:** MongoDB در حال اجرا نیست
```bash
docker start mlm-mongodb
```

### ❌ خطا: "Port already in use"
**علت:** پورت قبلاً استفاده شده
```bash
# پیدا کردن process:
sudo lsof -i :8001
# یا
sudo lsof -i :3000

# کشتن process:
sudo kill -9 <PID>
```

### ❌ خطا: "CORS Error" در مرورگر
**علت:** Backend اجرا نشده یا CORS غلط تنظیم شده
```bash
# چک کنید Backend اجرا شده:
curl http://localhost:8001/api/health

# اگر اجرا نشده، راه‌اندازی کنید:
cd backend
source venv/bin/activate
python server.py
```

### ❌ خطا: "Cannot find module"
**علت:** Dependencies نصب نشدند
```bash
# Backend:
cd backend
source venv/bin/activate
pip install -r requirements.txt

# Frontend:
cd frontend
yarn install
```

### ❌ خطا: "User not found" هنگام Login
**علت:** کاربر Admin ایجاد نشده
```bash
# ایجاد Admin:
curl -X POST http://localhost:8001/api/setup/init
```

---

## 📁 ساختار پروژه

```
amozeshi_final/
├── backend/
│   ├── server.py           # سرور اصلی (با entry point)
│   ├── config.py           # تنظیمات
│   ├── database.py         # اتصال MongoDB
│   ├── routes/             # API endpoints
│   ├── services/           # منطق کسب‌وکار
│   │   ├── tree/          # مدیریت درخت MLM
│   │   ├── rewards/       # سیستم پاداش
│   │   └── user/          # مدیریت کاربر
│   ├── models/            # مدل‌های داده
│   ├── requirements.txt   # وابستگی‌های Python
│   └── .env              # تنظیمات محیطی (ساخته می‌شود)
│
├── frontend/
│   ├── src/
│   │   └── components/    # کامپوننت‌های React
│   ├── package.json       # وابستگی‌های Node
│   └── .env              # تنظیمات Frontend (ساخته می‌شود)
│
├── docs/                  # مستندات
├── install.sh            # اسکریپت نصب خودکار
└── README_INSTALL.md     # این فایل
```

---

## 🔒 امنیت

### Production:
1. ✅ رمز Admin را تغییر دهید
2. ✅ JWT_SECRET را عوض کنید (در `backend/.env`)
3. ✅ Firewall را تنظیم کنید:
   ```bash
   sudo ufw allow 8001
   sudo ufw allow 3000
   sudo ufw enable
   ```
4. ✅ از HTTPS استفاده کنید (Nginx + Let's Encrypt)
5. ✅ MongoDB را با authentication راه‌اندازی کنید

---

## 📊 مانیتورینگ

### لاگ‌ها:
```bash
# Backend logs:
tail -f backend/logs/mlm_system.log

# MongoDB logs:
docker logs mlm-mongodb -f

# Install log:
cat install.log
```

### Performance:
```bash
# MongoDB stats:
docker exec mlm-mongodb mongo mlm_production --eval "db.stats()"

# Users count:
docker exec mlm-mongodb mongo mlm_production --eval "db.users.count()"
```

---

## 🎯 ویژگی‌های سیستم

### ✅ MLM با Materialized Path:
- درخت 3-ary (هر کاربر 3 فرزند)
- 7 سطح پاداش
- محاسبه real-time بدون traversal
- آماده برای 100,000+ کاربر

### ✅ سیستم پاداش:
- پاداش مستقیم (Direct Reward)
- پاداش سطحی (Level 3, 5, 7)
- مدیریت تراکنش‌ها

### ✅ پنل مدیریت:
- مدیریت کاربران
- تأیید پرداخت‌ها
- آمار و گزارش‌ها
- تنظیمات سیستم

### ✅ پنل کاربری:
- داشبورد شخصی
- مشاهده درخت
- تاریخچه تراکنش‌ها
- لینک معرفی

---

## 🆘 پشتیبانی

اگر با مشکلی مواجه شدید:

1. **لاگ‌ها را بررسی کنید:**
   ```bash
   tail -f backend/logs/mlm_system.log
   ```

2. **Console مرورگر را چک کنید** (F12 > Console)

3. **Health Check را تست کنید:**
   ```bash
   curl http://localhost:8001/api/health
   ```

4. **Docker را بررسی کنید:**
   ```bash
   docker ps -a
   ```

---

## 📝 نکات مهم

1. ✅ حتماً `install.sh` را با sudo اجرا کنید
2. ✅ Backend و Frontend را در terminal‌های جداگانه اجرا کنید
3. ✅ MongoDB باید قبل از Backend اجرا شود
4. ✅ برای Production حتماً Build کنید: `yarn build`
5. ✅ فایل `.env` را در Git commit نکنید

---

## 🎉 موفق باشید!

سیستم شما آماده استفاده است. برای شروع:

1. ✅ Backend را اجرا کنید
2. ✅ Frontend را اجرا کنید
3. ✅ مرورگر را باز کنید: `http://localhost:3000`
4. ✅ با `admin@mlm.com` / `admin123` وارد شوید

---

**نسخه:** 2.0.0 Final (Fixed Login)
**تاریخ:** 2025-12-19
