"""Ticket Models - مدل‌های تیکت"""

from pydantic import BaseModel, Field
from typing import Optional, List


class TicketCreate(BaseModel):
    """ایجاد تیکت جدید"""
    subject: str = Field(min_length=3, max_length=200)
    message: str = Field(min_length=10, max_length=5000)
    priority: str = Field(default="normal")  # low, normal, high


class TicketReply(BaseModel):
    """پاسخ به تیکت"""
    message: str = Field(min_length=1, max_length=5000)


class TicketMessage(BaseModel):
    """پیام داخل تیکت"""
    message_id: str
    sender_id: str
    sender_email: str
    sender_role: str  # user or admin
    message: str
    timestamp: str


class Ticket(BaseModel):
    """مدل کامل تیکت"""
    ticket_id: str
    user_id: str
    user_email: str
    subject: str
    priority: str = "normal"
    status: str = "open"  # open, answered, closed
    messages: List[TicketMessage] = []
    created_at: str
    updated_at: str
    closed_at: Optional[str] = None
