"""Withdrawal Models - مدل‌های برداشت"""

from pydantic import BaseModel, Field
from typing import Optional


class WithdrawalRequest(BaseModel):
    """درخواست برداشت از کاربر"""
    amount: float = Field(gt=0, description="مبلغ برداشت")
    wallet_address: str = Field(min_length=10, description="آدرس کیف پول")
    network: str = Field(default="TRON", description="شبکه - TRON یا BSC")


class Withdrawal(BaseModel):
    """مدل کامل برداشت"""
    withdrawal_id: str
    user_id: str
    amount: float
    fee: float = 0.0
    net_amount: float  # مبلغ خالص پس از کسر کارمزد
    wallet_address: str
    network: str
    status: str = "pending_admin"  # pending_admin, processing, completed, rejected
    tx_hash: Optional[str] = None
    rejection_reason: Optional[str] = None
    requested_at: str
    processed_at: Optional[str] = None
    processed_by: Optional[str] = None


class WithdrawalProcess(BaseModel):
    """مدل پردازش برداشت توسط ادمین"""
    tx_hash: Optional[str] = None
    rejection_reason: Optional[str] = None
