#!/bin/bash

################################################################################
# MLM System - Stop Script
# توقف تمام سرویس‌ها
################################################################################

RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

echo -e "${YELLOW}🛑 توقف سیستم MLM...${NC}"
echo ""

# چک روش deployment
if [ -f "docker-compose.yml" ] && command -v docker &> /dev/null; then
    echo -e "${YELLOW}⏳ توقف Docker Compose...${NC}"
    sudo docker compose down
    echo -e "${GREEN}✔ Docker Compose متوقف شد${NC}"
elif command -v pm2 &> /dev/null; then
    echo -e "${YELLOW}⏳ توقف PM2 سرویس‌ها...${NC}"
    pm2 stop all
    echo -e "${GREEN}✔ PM2 سرویس‌ها متوقف شدند${NC}"
else
    echo -e "${RED}❌ روش deployment شناسایی نشد${NC}"
    exit 1
fi

echo ""
echo -e "${GREEN}✔ سیستم متوقف شد${NC}"
echo ""
