#!/bin/bash

################################################################################
# MLM System - Start Script  
# شروع تمام سرویس‌ها
################################################################################

RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
NC='\033[0m'

echo -e "${YELLOW}🚀 شروع سیستم MLM...${NC}"
echo ""

# چک روش deployment
if [ -f "docker-compose.yml" ] && command -v docker &> /dev/null; then
    echo -e "${YELLOW}⏳ شروع Docker Compose...${NC}"
    sudo docker compose up -d
    echo -e "${GREEN}✔ Docker Compose راه‌اندازی شد${NC}"
    
    sleep 5
    echo ""
    echo -e "${YELLOW}📊 وضعیت:${NC}"
    sudo docker compose ps
    
elif command -v pm2 &> /dev/null; then
    echo -e "${YELLOW}⏳ شروع PM2 سرویس‌ها...${NC}"
    pm2 start all
    echo -e "${GREEN}✔ PM2 سرویس‌ها راه‌اندازی شدند${NC}"
    
    sleep 2
    echo ""
    echo -e "${YELLOW}📊 وضعیت:${NC}"
    pm2 list
    
else
    echo -e "${RED}❌ روش deployment شناسایی نشد${NC}"
    exit 1
fi

echo ""
echo -e "${GREEN}✔ سیستم راه‌اندازی شد${NC}"

SERVER_IP=$(curl -s ifconfig.me 2>/dev/null || hostname -I | awk '{print $1}')
echo ""
echo -e "${GREEN}🌐 دسترسی: http://$SERVER_IP${NC}"
echo ""
