"""User Profile Service - مدیریت پروفایل کاربر"""

from typing import Dict
import logging

logger = logging.getLogger(__name__)

_db = None

def set_database(db):
    """تنظیم database connection"""
    global _db
    _db = db


class UserProfileService:
    """سرویس مدیریت پروفایل کاربر"""
    
    @staticmethod
    async def get_profile(user_id: str) -> Dict:
        """
        دریافت اطلاعات پروفایل کاربر
        
        Args:
            user_id: شناسه کاربر
            
        Returns:
            اطلاعات کامل کاربر
        """
        user = await _db.users.find_one(
            {"user_id": user_id},
            {"_id": 0, "password": 0}  # بدون password
        )
        
        return user
    
    @staticmethod
    async def update_wallet(user_id: str, wallet_address: str, wallet_network: str) -> bool:
        """
        بروزرسانی اطلاعات کیف پول
        
        Args:
            user_id: شناسه کاربر
            wallet_address: آدرس کیف پول
            wallet_network: شبکه (TRON, BSC, etc.)
            
        Returns:
            True اگر موفق باشد
        """
        result = await _db.users.update_one(
            {"user_id": user_id},
            {"$set": {
                "wallet_address": wallet_address,
                "wallet_network": wallet_network
            }}
        )
        
        return result.modified_count > 0
