"""Announcement Models - مدل‌های اطلاعیه"""

from pydantic import BaseModel, Field
from typing import Optional, List


class AnnouncementCreate(BaseModel):
    """ایجاد اطلاعیه جدید"""
    title: str = Field(min_length=1, max_length=200)
    content: str = Field(min_length=1, max_length=10000)
    link: Optional[str] = None
    is_modal: bool = False  # نمایش به صورت modal
    is_active: bool = True


class Announcement(BaseModel):
    """مدل کامل اطلاعیه"""
    announcement_id: str
    title: str
    content: str
    link: Optional[str] = None
    is_modal: bool = False
    is_active: bool = True
    created_at: str
    created_by: str
    seen_by: List[str] = []  # لیست کاربرانی که دیده‌اند
