<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تست سیستم MLM</title>
    <style>
        body { font-family: Tahoma; padding: 20px; background: #f5f7fa; }
        .test { background: white; padding: 20px; margin: 10px 0; border-radius: 10px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .success { color: #27ae60; font-weight: bold; }
        .error { color: #e74c3c; font-weight: bold; }
        .warning { color: #f39c12; font-weight: bold; }
        h1 { color: #2c3e50; }
        h2 { color: #34495e; border-bottom: 2px solid #3498db; padding-bottom: 10px; }
        pre { background: #f4f4f4; padding: 10px; border-radius: 5px; overflow: auto; }
        .btn { padding: 10px 20px; background: #3498db; color: white; text-decoration: none; border-radius: 5px; display: inline-block; margin: 5px; }
    </style>
</head>
<body>
    <h1>🧪 تست سیستم MLM - cPanel</h1>
    
    <?php
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    
    $tests = [];
    
    // Test 1: PHP Version
    echo "<div class='test'><h2>1️⃣ بررسی PHP Version</h2>";
    $phpVersion = phpversion();
    if (version_compare($phpVersion, '7.4.0', '>=')) {
        echo "<p class='success'>✅ PHP Version: {$phpVersion} (مناسب)</p>";
        $tests['php'] = true;
    } else {
        echo "<p class='error'>❌ PHP Version: {$phpVersion} (نامناسب - نیاز به 7.4+)</p>";
        $tests['php'] = false;
    }
    echo "</div>";
    
    // Test 2: Extensions
    echo "<div class='test'><h2>2️⃣ بررسی PHP Extensions</h2>";
    $required = ['pdo', 'pdo_mysql', 'mbstring', 'json'];
    $allOk = true;
    foreach ($required as $ext) {
        if (extension_loaded($ext)) {
            echo "<p class='success'>✅ {$ext}</p>";
        } else {
            echo "<p class='error'>❌ {$ext} نصب نیست!</p>";
            $allOk = false;
        }
    }
    $tests['extensions'] = $allOk;
    echo "</div>";
    
    // Test 3: Files
    echo "<div class='test'><h2>3️⃣ بررسی فایل‌ها</h2>";
    $files = [
        'config/database.php',
        'includes/Database.php',
        'includes/UserService.php',
        'includes/TreeService.php',
        'includes/CacheService.php',
        'includes/QueueService.php',
        'api/index.php',
        'cron/worker.php'
    ];
    $allOk = true;
    foreach ($files as $file) {
        if (file_exists(__DIR__ . '/' . $file)) {
            echo "<p class='success'>✅ {$file}</p>";
        } else {
            echo "<p class='error'>❌ {$file} یافت نشد!</p>";
            $allOk = false;
        }
    }
    $tests['files'] = $allOk;
    echo "</div>";
    
    // Test 4: Database Config
    echo "<div class='test'><h2>4️⃣ بررسی تنظیمات Database</h2>";
    try {
        if (file_exists(__DIR__ . '/config/database.php')) {
            $config = require __DIR__ . '/config/database.php';
            echo "<p class='success'>✅ فایل config خوانده شد</p>";
            echo "<p>Database: <strong>{$config['database']}</strong></p>";
            echo "<p>Username: <strong>{$config['username']}</strong></p>";
            echo "<p>Host: <strong>{$config['host']}</strong></p>";
            
            // Check if default values
            if ($config['database'] === 'YOUR_DATABASE_NAME') {
                echo "<p class='warning'>⚠️ هنوز تنظیمات database رو ویرایش نکردی!</p>";
                $tests['config'] = false;
            } else {
                $tests['config'] = true;
            }
        } else {
            echo "<p class='error'>❌ فایل config/database.php وجود ندارد!</p>";
            $tests['config'] = false;
        }
    } catch (Exception $e) {
        echo "<p class='error'>❌ خطا: " . $e->getMessage() . "</p>";
        $tests['config'] = false;
    }
    echo "</div>";
    
    // Test 5: Database Connection
    echo "<div class='test'><h2>5️⃣ بررسی اتصال به Database</h2>";
    if ($tests['config'] && $tests['files']) {
        try {
            require_once __DIR__ . '/includes/Database.php';
            $db = Database::getInstance();
            echo "<p class='success'>✅ اتصال به دیتابیس موفق!</p>";
            
            // Check tables
            $tables = $db->fetchAll("SHOW TABLES");
            echo "<p>تعداد جداول: <strong>" . count($tables) . "</strong></p>";
            
            if (count($tables) >= 10) {
                echo "<p class='success'>✅ جداول به درستی import شده‌اند</p>";
                $tests['database'] = true;
            } else {
                echo "<p class='warning'>⚠️ تعداد جداول کم است. باید حداقل 10 جدول باشد.</p>";
                $tests['database'] = false;
            }
            
            // Check seed user
            $seed = $db->fetchOne("SELECT * FROM users WHERE user_id = 'seed'");
            if ($seed) {
                echo "<p class='success'>✅ کاربر seed موجود است</p>";
            } else {
                echo "<p class='error'>❌ کاربر seed موجود نیست!</p>";
                $tests['database'] = false;
            }
            
        } catch (Exception $e) {
            echo "<p class='error'>❌ خطا: " . $e->getMessage() . "</p>";
            $tests['database'] = false;
        }
    } else {
        echo "<p class='warning'>⚠️ ابتدا مراحل قبل را کامل کنید</p>";
        $tests['database'] = false;
    }
    echo "</div>";
    
    // Test 6: Permissions
    echo "<div class='test'><h2>6️⃣ بررسی Permissions</h2>";
    $writable = ['logs'];
    $allOk = true;
    foreach ($writable as $dir) {
        if (is_writable(__DIR__ . '/' . $dir)) {
            echo "<p class='success'>✅ {$dir} قابل نوشتن است</p>";
        } else {
            echo "<p class='warning'>⚠️ {$dir} قابل نوشتن نیست</p>";
            $allOk = false;
        }
    }
    $tests['permissions'] = $allOk;
    echo "</div>";
    
    // Test 7: Cache System
    echo "<div class='test'><h2>7️⃣ بررسی Cache System</h2>";
    if ($tests['database']) {
        try {
            require_once __DIR__ . '/includes/CacheService.php';
            $cache = CacheService::getInstance();
            
            // Test set
            $cache->set('test_key', 'test_value', 60);
            
            // Test get
            $value = $cache->get('test_key');
            
            if ($value === 'test_value') {
                echo "<p class='success'>✅ Cache کار می‌کند (Database Cache)</p>";
                echo "<p class='warning'>💡 برای سرعت بیشتر، Redis نصب کنید (اختیاری)</p>";
                $tests['cache'] = true;
            } else {
                echo "<p class='error'>❌ Cache کار نمی‌کند</p>";
                $tests['cache'] = false;
            }
            
            // Cleanup
            $cache->delete('test_key');
            
        } catch (Exception $e) {
            echo "<p class='error'>❌ خطا: " . $e->getMessage() . "</p>";
            $tests['cache'] = false;
        }
    } else {
        echo "<p class='warning'>⚠️ ابتدا database را تنظیم کنید</p>";
        $tests['cache'] = false;
    }
    echo "</div>";
    
    // Summary
    echo "<div class='test'><h2>📊 خلاصه نتایج</h2>";
    $total = count($tests);
    $passed = count(array_filter($tests));
    $percentage = round(($passed / $total) * 100);
    
    echo "<p><strong>تست‌های موفق:</strong> {$passed} از {$total}</p>";
    echo "<p><strong>درصد موفقیت:</strong> {$percentage}%</p>";
    
    if ($percentage === 100) {
        echo "<p class='success' style='font-size: 18px;'>🎉 همه چیز آماده است! سیستم کاملاً نصب شده.</p>";
        echo "<p><a href='/admin/login.php' class='btn'>رفتن به پنل ادمین</a></p>";
        echo "<p><a href='/pages/auth/register.php' class='btn'>رفتن به ثبت‌نام</a></p>";
    } elseif ($percentage >= 70) {
        echo "<p class='warning' style='font-size: 18px;'>⚠️ تقریباً آماده است. چند مورد نیاز به بررسی دارد.</p>";
    } else {
        echo "<p class='error' style='font-size: 18px;'>❌ نصب ناقص است. مراحل بالا را بررسی کنید.</p>";
    }
    echo "</div>";
    
    // Next Steps
    echo "<div class='test'><h2>🔧 مراحل بعدی</h2>";
    if (!$tests['config']) {
        echo "<p>1. فایل <code>config/database.php</code> را ویرایش کنید</p>";
    }
    if (!$tests['database']) {
        echo "<p>2. فایل <code>database/schema.sql</code> را در phpMyAdmin import کنید</p>";
    }
    if ($percentage === 100) {
        echo "<p>✅ همه چیز آماده است!</p>";
        echo "<p>مرحله بعد: Setup Cron Job در cPanel</p>";
        echo "<pre>Command: php " . __DIR__ . "/cron/worker.php</pre>";
    }
    echo "</div>";
    
    // System Info
    echo "<div class='test'><h2>ℹ️ اطلاعات سیستم</h2>";
    echo "<p><strong>PHP Version:</strong> " . phpversion() . "</p>";
    echo "<p><strong>Server Software:</strong> " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "</p>";
    echo "<p><strong>Document Root:</strong> " . __DIR__ . "</p>";
    echo "<p><strong>Current Time:</strong> " . date('Y-m-d H:i:s') . "</p>";
    echo "</div>";
    ?>
    
    <div style="text-align: center; margin-top: 30px; color: #7f8c8d;">
        <p>MLM System v4.0 - Optimized for cPanel</p>
        <p><a href="INSTALL_CPANEL.md" target="_blank">راهنمای کامل نصب</a></p>
    </div>
</body>
</html>
