<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>برداشت - سیستم MLM</title>
    <link rel="stylesheet" href="index.php" style="display:none;">
    <style>
        /* استایل‌های مشابه dashboard */
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI'; background: #f5f7fa; direction: rtl; padding: 20px; }
        .container { max-width: 800px; margin: 0 auto; }
        .card { background: white; padding: 30px; border-radius: 15px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .card h2 { color: #2c3e50; margin-bottom: 20px; }
        .balance-card { background: linear-gradient(135deg, #27ae60 0%, #229954 100%); color: white; padding: 30px; border-radius: 15px; text-align: center; margin-bottom: 20px; }
        .balance-card .amount { font-size: 48px; font-weight: bold; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; font-weight: bold; color: #2c3e50; margin-bottom: 8px; }
        .form-group input, .form-group select { width: 100%; padding: 12px; border: 2px solid #e0e0e0; border-radius: 8px; }
        .btn { padding: 12px 24px; border: none; border-radius: 8px; cursor: pointer; font-size: 14px; font-weight: bold; }
        .btn-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; width: 100%; }
        .btn-secondary { background: #95a5a6; color: white; }
        table { width: 100%; border-collapse: collapse; }
        table th { background: #f8f9fa; padding: 12px; text-align: right; font-weight: 600; border-bottom: 2px solid #dee2e6; }
        table td { padding: 12px; border-bottom: 1px solid #dee2e6; }
        .badge { padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; }
        .badge.success { background: #d4edda; color: #155724; }
        .badge.warning { background: #fff3cd; color: #856404; }
        .badge.danger { background: #f8d7da; color: #721c24; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h2>💸 درخواست برداشت</h2>
            
            <div class="balance-card">
                <p style="font-size: 18px; margin-bottom: 10px;">موجودی قابل برداشت:</p>
                <div class="amount">$<span id="availableBalance">0</span></div>
            </div>
            
            <div id="withdrawalForm" class="card" style="background: #f8f9fa;">
                <h3 style="margin-bottom: 15px;">درخواست جدید</h3>
                <form id="requestForm">
                    <div class="form-group">
                        <label>مبلغ (USDT):</label>
                        <input type="number" name="amount" min="10" step="0.01" required>
                        <p style="font-size: 12px; color: #666; margin-top: 5px;">حداقل برداشت: $10 | کارمزد: 2%</p>
                    </div>
                    <div class="form-group">
                        <label>آدرس کیف پول:</label>
                        <input type="text" name="wallet_address" required>
                    </div>
                    <div class="form-group">
                        <label>شبکه:</label>
                        <select name="network">
                            <option value="BSC">BSC (BEP20)</option>
                            <option value="TRON">Tron (TRC20)</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">ارسال درخواست</button>
                </form>
            </div>
            
            <div class="card">
                <h2>📋 تاریخچه برداشت‌ها</h2>
                <div id="withdrawalHistory">در حال بارگذاری...</div>
            </div>
        </div>
    </div>
    
    <script>
        const API_BASE = window.location.origin + '/api';
        const userId = localStorage.getItem('user_id');
        
        async function loadData() {
            const userRes = await fetch(`${API_BASE}/user/${userId}`);
            const userData = await userRes.json();
            if (userData.success) {
                const available = userData.data.total_points - userData.data.pending_withdrawal;
                document.getElementById('availableBalance').textContent = available.toFixed(2);
            }
            
            const historyRes = await fetch(`${API_BASE}/withdrawal/list/${userId}`);
            const historyData = await historyRes.json();
            if (historyData.success) {
                displayHistory(historyData.data.withdrawals);
            }
        }
        
        function displayHistory(withdrawals) {
            if (!withdrawals || withdrawals.length === 0) {
                document.getElementById('withdrawalHistory').innerHTML = '<p style="text-align:center;padding:20px;color:#7f8c8d;">هنوز درخواستی ندارید</p>';
                return;
            }
            
            const html = `<table>
                <thead><tr><th>مبلغ</th><th>کارمزد</th><th>خالص</th><th>وضعیت</th><th>تاریخ</th></tr></thead>
                <tbody>${withdrawals.map(w => `<tr>
                    <td>$${parseFloat(w.amount).toFixed(2)}</td>
                    <td>$${parseFloat(w.fee || 0).toFixed(2)}</td>
                    <td>$${parseFloat(w.net_amount || w.amount).toFixed(2)}</td>
                    <td><span class="badge ${w.status === 'completed' ? 'success' : w.status === 'rejected' ? 'danger' : 'warning'}">${w.status}</span></td>
                    <td>${new Date(w.created_at).toLocaleDateString('fa-IR')}</td>
                </tr>`).join('')}</tbody>
            </table>`;
            document.getElementById('withdrawalHistory').innerHTML = html;
        }
        
        document.getElementById('requestForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            const formData = new FormData(e.target);
            const data = {
                user_id: userId,
                amount: parseFloat(formData.get('amount')),
                wallet_address: formData.get('wallet_address'),
                network: formData.get('network')
            };
            
            const res = await fetch(`${API_BASE}/withdrawal/request`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            
            const result = await res.json();
            if (result.success) {
                alert('درخواست ثبت شد و در انتظار تایید است');
                e.target.reset();
                loadData();
            } else {
                alert('خطا: ' + (result.error || 'مشکلی پیش آمد'));
            }
        });
        
        loadData();
    </script>
</body>
</html>
