<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>درخت من - سیستم MLM</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI'; background: #f5f7fa; direction: rtl; padding: 20px; }
        .container { max-width: 1200px; margin: 0 auto; }
        .card { background: white; padding: 30px; border-radius: 15px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .tree-node { border: 2px solid #3498db; border-radius: 10px; padding: 15px; margin: 10px; background: white; text-align: center; min-width: 150px; }
        .tree-node.active { background: #d4edda; border-color: #27ae60; }
        .tree-node.pending { background: #fff3cd; border-color: #ffc107; }
        .tree-container { display: flex; flex-direction: column; align-items: center; }
        .level { display: flex; justify-content: center; gap: 20px; margin: 20px 0; flex-wrap: wrap; }
        .stats { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px; }
        .stat-box { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 10px; text-align: center; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h2>🌳 درخت من</h2>
            <div class="stats">
                <div class="stat-box"><h3 id="totalDesc">0</h3><p>کل زیرمجموعه</p></div>
                <div class="stat-box"><h3 id="directRef">0</h3><p>معرفی مستقیم</p></div>
                <div class="stat-box"><h3 id="treeStatus">ناقص</h3><p>وضعیت درخت</p></div>
            </div>
            <div id="treeView" class="tree-container">در حال بارگذاری...</div>
        </div>
    </div>
    <script>
        const API_BASE = window.location.origin + '/api';
        const userId = localStorage.getItem('user_id');
        
        async function loadTree() {
            const res = await fetch(`${API_BASE}/tree/${userId}`);
            const data = await res.json();
            if (data.success) {
                displayTree(data.data);
            }
            
            const statsRes = await fetch(`${API_BASE}/tree-stats/${userId}`);
            const statsData = await statsRes.json();
            if (statsData.success) {
                document.getElementById('totalDesc').textContent = statsData.data.total_descendants;
                document.getElementById('directRef').textContent = statsData.data.direct_referrals;
                document.getElementById('treeStatus').textContent = statsData.data.is_tree_complete ? 'کامل ✅' : 'ناقص';
            }
        }
        
        function displayTree(tree) {
            let html = '<div class="level">';
            html += createNode(tree);
            html += '</div>';
            
            if (tree.children && tree.children.length > 0) {
                html += '<div class="level">';
                tree.children.forEach(child => {
                    html += createNode(child);
                });
                html += '</div>';
            }
            
            document.getElementById('treeView').innerHTML = html;
        }
        
        function createNode(node) {
            const statusClass = node.status === 'active' ? 'active' : 'pending';
            return `<div class="tree-node ${statusClass}">
                <div><strong>${node.email}</strong></div>
                <div style="font-size:12px;color:#666;">موقعیت: ${node.position}</div>
                <div style="font-size:12px;color:#666;">عمق: ${node.depth}</div>
            </div>`;
        }
        
        loadTree();
    </script>
</body>
</html>
