<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پرداخت و فعال‌سازی - سیستم MLM</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
            direction: rtl;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .card {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        
        .card h2 {
            color: #2c3e50;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .payment-amount {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 15px;
            text-align: center;
            margin-bottom: 20px;
        }
        
        .payment-amount h3 {
            font-size: 18px;
            margin-bottom: 10px;
            opacity: 0.9;
        }
        
        .payment-amount .amount {
            font-size: 48px;
            font-weight: bold;
        }
        
        .wallet-address {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .wallet-address label {
            display: block;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 10px;
        }
        
        .wallet-input {
            display: flex;
            gap: 10px;
        }
        
        .wallet-input input {
            flex: 1;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-family: monospace;
            font-size: 13px;
        }
        
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
            transition: transform 0.2s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-secondary {
            background: #95a5a6;
            color: white;
        }
        
        .qr-code {
            text-align: center;
            padding: 20px;
        }
        
        .qr-code img {
            max-width: 250px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 10px;
        }
        
        .network-selector {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }
        
        .network-btn {
            flex: 1;
            padding: 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            background: white;
            cursor: pointer;
            text-align: center;
            transition: all 0.3s;
        }
        
        .network-btn.active {
            border-color: #667eea;
            background: #f0f4ff;
        }
        
        .network-btn img {
            width: 40px;
            height: 40px;
            margin-bottom: 8px;
        }
        
        .instructions {
            background: #fff3cd;
            padding: 20px;
            border-radius: 10px;
            border-right: 4px solid #ffc107;
            margin-bottom: 20px;
        }
        
        .instructions ol {
            margin-right: 20px;
        }
        
        .instructions li {
            margin: 10px 0;
            color: #856404;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 8px;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
        }
        
        .success-message {
            background: #d4edda;
            color: #155724;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .error-message {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .loading {
            text-align: center;
            padding: 40px;
        }
        
        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin: 0 auto 15px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h2>💳 پرداخت و فعال‌سازی حساب</h2>
            
            <div id="loading" class="loading">
                <div class="spinner"></div>
                <p style="color: #7f8c8d;">در حال بارگذاری...</p>
            </div>
            
            <div id="content" style="display: none;">
                <div class="payment-amount">
                    <h3>مبلغ قابل پرداخت:</h3>
                    <div class="amount">100 USDT</div>
                    <p style="margin-top: 10px; font-size: 14px; opacity: 0.9;">
                        هزینه فعال‌سازی یکبار پرداخت
                    </p>
                </div>
                
                <!-- Network Selection -->
                <div class="card" style="padding: 20px; background: #f8f9fa;">
                    <label style="display: block; margin-bottom: 15px; font-weight: bold;">انتخاب شبکه:</label>
                    <div class="network-selector">
                        <div class="network-btn active" onclick="selectNetwork('BSC')">
                            <div style="font-size: 24px;">🟡</div>
                            <div style="font-weight: bold; margin-top: 5px;">BSC</div>
                            <div style="font-size: 11px; color: #666;">BEP20</div>
                        </div>
                        <div class="network-btn" onclick="selectNetwork('TRON')">
                            <div style="font-size: 24px;">🔴</div>
                            <div style="font-weight: bold; margin-top: 5px;">Tron</div>
                            <div style="font-size: 11px; color: #666;">TRC20</div>
                        </div>
                    </div>
                </div>
                
                <!-- Instructions -->
                <div class="instructions">
                    <strong>📋 مراحل پرداخت:</strong>
                    <ol>
                        <li>شبکه مورد نظر را انتخاب کنید (BSC یا Tron)</li>
                        <li>آدرس کیف پول را کپی کنید</li>
                        <li>از کیف پول خود 100 USDT به آدرس زیر ارسال کنید</li>
                        <li>Transaction Hash را در فرم زیر وارد کنید</li>
                        <li>منتظر تایید بمانید (معمولاً چند دقیقه)</li>
                    </ol>
                </div>
                
                <!-- Wallet Address -->
                <div class="wallet-address">
                    <label>آدرس کیف پول سیستم (<span id="networkName">BSC</span>):</label>
                    <div class="wallet-input">
                        <input type="text" id="walletAddress" readonly>
                        <button class="btn btn-primary" onclick="copyWallet()">کپی</button>
                    </div>
                </div>
                
                <!-- QR Code -->
                <div class="qr-code">
                    <p style="margin-bottom: 10px; color: #7f8c8d;">اسکن QR Code:</p>
                    <img id="qrCode" src="" alt="QR Code">
                </div>
                
                <!-- TX Hash Form -->
                <div class="card" style="background: #f8f9fa;">
                    <h3 style="margin-bottom: 15px;">✅ تایید پرداخت</h3>
                    
                    <div id="successMessage" class="success-message" style="display: none;"></div>
                    <div id="errorMessage" class="error-message" style="display: none;"></div>
                    
                    <form id="verifyForm">
                        <div class="form-group">
                            <label>Transaction Hash (TX Hash):</label>
                            <input type="text" name="tx_hash" required placeholder="0x...">
                            <p style="font-size: 12px; color: #666; margin-top: 5px;">
                                شناسه تراکنش خود را از کیف پول کپی کنید
                            </p>
                        </div>
                        
                        <button type="submit" class="btn btn-primary" style="width: 100%;">
                            تایید و فعال‌سازی حساب
                        </button>
                    </form>
                </div>
                
                <div style="text-align: center; margin-top: 20px;">
                    <a href="index.php" class="btn btn-secondary">بازگشت به داشبورد</a>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        const API_BASE = window.location.origin + '/api';
        const userId = localStorage.getItem('user_id');
        let currentNetwork = 'BSC';
        let paymentId = null;
        
        // Wallet addresses (از settings خوانده می‌شود)
        const wallets = {
            'BSC': '0x742d35Cc6634C0532925a3b844Bc9e7595f0bEb8', // مثال - باید از API بیاد
            'TRON': 'TYASr5UV6HEcXatwdFQfmLVUqQQQMUxHLS' // مثال
        };
        
        async function init() {
            if (!userId) {
                window.location.href = '../auth/login.php';
                return;
            }
            
            // بررسی وضعیت کاربر
            const response = await fetch(`${API_BASE}/user/${userId}`);
            const data = await response.json();
            
            if (data.success && data.data.status === 'active') {
                alert('حساب شما قبلاً فعال شده است');
                window.location.href = 'index.php';
                return;
            }
            
            // ساخت payment
            const paymentResponse = await fetch(`${API_BASE}/payment/create`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    user_id: userId,
                    amount: 100,
                    wallet_address: wallets[currentNetwork],
                    network: currentNetwork
                })
            });
            
            const paymentData = await paymentResponse.json();
            if (paymentData.success) {
                paymentId = paymentData.payment_id;
            }
            
            updateWallet();
            document.getElementById('loading').style.display = 'none';
            document.getElementById('content').style.display = 'block';
        }
        
        function selectNetwork(network) {
            currentNetwork = network;
            document.querySelectorAll('.network-btn').forEach(btn => btn.classList.remove('active'));
            event.target.closest('.network-btn').classList.add('active');
            updateWallet();
        }
        
        function updateWallet() {
            const wallet = wallets[currentNetwork];
            document.getElementById('walletAddress').value = wallet;
            document.getElementById('networkName').textContent = currentNetwork;
            
            // QR Code
            const qrUrl = `https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=${wallet}`;
            document.getElementById('qrCode').src = qrUrl;
        }
        
        function copyWallet() {
            const input = document.getElementById('walletAddress');
            input.select();
            document.execCommand('copy');
            alert('آدرس کیف پول کپی شد!');
        }
        
        document.getElementById('verifyForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const txHash = e.target.tx_hash.value;
            const successMsg = document.getElementById('successMessage');
            const errorMsg = document.getElementById('errorMessage');
            
            successMsg.style.display = 'none';
            errorMsg.style.display = 'none';
            
            const submitBtn = e.target.querySelector('button[type="submit"]');
            submitBtn.disabled = true;
            submitBtn.textContent = 'در حال تایید...';
            
            try {
                const response = await fetch(`${API_BASE}/payment/verify`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({
                        payment_id: paymentId,
                        tx_hash: txHash
                    })
                });
                
                const result = await response.json();
                
                if (result.success && result.confirmed) {
                    successMsg.textContent = '✅ پرداخت تایید شد! حساب شما فعال شد. در حال انتقال...';
                    successMsg.style.display = 'block';
                    
                    // فعال‌سازی کاربر
                    await fetch(`${API_BASE}/activate`, {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({
                            user_id: userId,
                            payment_id: paymentId
                        })
                    });
                    
                    setTimeout(() => {
                        window.location.href = 'index.php';
                    }, 2000);
                } else {
                    errorMsg.textContent = result.error || 'تراکنش تایید نشد. لطفاً بررسی کنید.';
                    errorMsg.style.display = 'block';
                    submitBtn.disabled = false;
                    submitBtn.textContent = 'تایید و فعال‌سازی حساب';
                }
                
            } catch (error) {
                errorMsg.textContent = 'خطا در ارتباط با سرور';
                errorMsg.style.display = 'block';
                submitBtn.disabled = false;
                submitBtn.textContent = 'تایید و فعال‌سازی حساب';
            }
        });
        
        init();
    </script>
</body>
</html>
