<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ثبت‌نام - سیستم MLM</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            width: 100%;
            max-width: 500px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .header h1 {
            color: #2c3e50;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .header p {
            color: #7f8c8d;
            font-size: 14px;
        }
        
        .steps {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            padding: 0 20px;
        }
        
        .step {
            flex: 1;
            text-align: center;
            position: relative;
        }
        
        .step::after {
            content: '';
            position: absolute;
            top: 15px;
            left: 50%;
            width: 100%;
            height: 2px;
            background: #e0e0e0;
            z-index: -1;
        }
        
        .step:last-child::after {
            display: none;
        }
        
        .step-number {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #e0e0e0;
            color: #7f8c8d;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 5px;
            position: relative;
            z-index: 1;
        }
        
        .step.active .step-number {
            background: #667eea;
            color: white;
        }
        
        .step.completed .step-number {
            background: #27ae60;
            color: white;
        }
        
        .step-label {
            font-size: 12px;
            color: #7f8c8d;
        }
        
        .form-step {
            display: none;
        }
        
        .form-step.active {
            display: block;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #2c3e50;
            font-weight: 500;
        }
        
        .form-group input,
        .form-group select {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .form-group .hint {
            font-size: 12px;
            color: #7f8c8d;
            margin-top: 5px;
        }
        
        .btn {
            width: 100%;
            padding: 14px;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-secondary {
            background: #ecf0f1;
            color: #2c3e50;
            margin-top: 10px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .success-message,
        .error-message {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .success-message {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .error-message {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .referral-info {
            background: #e3f2fd;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .referral-info strong {
            color: #1976d2;
        }
        
        .login-link {
            text-align: center;
            margin-top: 20px;
            color: #7f8c8d;
        }
        
        .login-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
        }
        
        .loading {
            display: none;
            text-align: center;
            padding: 20px;
        }
        
        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎯 ثبت‌نام در سیستم MLM</h1>
            <p>به خانواده بزرگ ما بپیوندید</p>
        </div>
        
        <!-- Steps Indicator -->
        <div class="steps">
            <div class="step active" data-step="1">
                <div class="step-number">1</div>
                <div class="step-label">اطلاعات</div>
            </div>
            <div class="step" data-step="2">
                <div class="step-number">2</div>
                <div class="step-label">معرف</div>
            </div>
            <div class="step" data-step="3">
                <div class="step-number">3</div>
                <div class="step-label">تایید</div>
            </div>
        </div>
        
        <!-- Messages -->
        <div id="successMessage" class="success-message" style="display: none;"></div>
        <div id="errorMessage" class="error-message" style="display: none;"></div>
        
        <!-- Form -->
        <form id="registerForm">
            <!-- Step 1: Basic Info -->
            <div class="form-step active" data-step="1">
                <div class="form-group">
                    <label>ایمیل: *</label>
                    <input type="email" name="email" required>
                    <div class="hint">ایمیل معتبر خود را وارد کنید</div>
                </div>
                
                <div class="form-group">
                    <label>رمز عبور: *</label>
                    <input type="password" name="password" required minlength="8">
                    <div class="hint">حداقل 8 کاراکتر</div>
                </div>
                
                <div class="form-group">
                    <label>تکرار رمز عبور: *</label>
                    <input type="password" name="password_confirm" required>
                </div>
                
                <button type="button" class="btn btn-primary" onclick="nextStep(2)">بعدی</button>
            </div>
            
            <!-- Step 2: Referrer -->
            <div class="form-step" data-step="2">
                <div id="referrerInfo" class="referral-info" style="display: none;">
                    <strong>معرف شما:</strong> <span id="referrerName"></span>
                </div>
                
                <div class="form-group">
                    <label>کد معرف:</label>
                    <input type="text" name="referrer_id" id="referrerCode" value="seed">
                    <div class="hint">کد معرف خود را وارد کنید (پیش‌فرض: seed)</div>
                </div>
                
                <div class="form-group">
                    <label>شماره موبایل: (اختیاری)</label>
                    <input type="tel" name="phone_number" placeholder="09123456789">
                </div>
                
                <button type="button" class="btn btn-secondary" onclick="prevStep(1)">قبلی</button>
                <button type="button" class="btn btn-primary" onclick="nextStep(3)">بعدی</button>
            </div>
            
            <!-- Step 3: Confirm -->
            <div class="form-step" data-step="3">
                <h3 style="margin-bottom: 20px; color: #2c3e50;">اطلاعات شما:</h3>
                
                <div style="background: #f8f9fa; padding: 15px; border-radius: 10px; margin-bottom: 20px;">
                    <p style="margin-bottom: 10px;"><strong>ایمیل:</strong> <span id="confirmEmail"></span></p>
                    <p style="margin-bottom: 10px;"><strong>کد معرف:</strong> <span id="confirmReferrer"></span></p>
                    <p><strong>شماره موبایل:</strong> <span id="confirmPhone">-</span></p>
                </div>
                
                <div style="background: #fff3cd; padding: 15px; border-radius: 10px; margin-bottom: 20px; border: 1px solid #ffc107;">
                    <strong>⚠️ توجه:</strong> پس از ثبت‌نام، برای فعال‌سازی حساب باید مبلغ 100 USDT پرداخت کنید.
                </div>
                
                <button type="button" class="btn btn-secondary" onclick="prevStep(2)">قبلی</button>
                <button type="submit" class="btn btn-primary">ثبت‌نام</button>
            </div>
        </form>
        
        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p style="margin-top: 10px; color: #7f8c8d;">در حال پردازش...</p>
        </div>
        
        <div class="login-link">
            قبلاً ثبت‌نام کرده‌اید؟ <a href="login.php">ورود</a>
        </div>
    </div>
    
    <script>
        const API_BASE = window.location.origin + '/api';
        let currentStep = 1;
        
        // دریافت referrer از URL
        const urlParams = new URLSearchParams(window.location.search);
        const refCode = urlParams.get('ref');
        if (refCode) {
            document.getElementById('referrerCode').value = refCode;
        }
        
        // مدیریت Steps
        function nextStep(step) {
            if (!validateStep(currentStep)) {
                return;
            }
            
            // Update UI
            document.querySelectorAll('.form-step').forEach(el => el.classList.remove('active'));
            document.querySelectorAll('.step').forEach(el => el.classList.remove('active'));
            
            document.querySelector(`.form-step[data-step="${step}"]`).classList.add('active');
            document.querySelector(`.step[data-step="${step}"]`).classList.add('active');
            document.querySelector(`.step[data-step="${currentStep}"]`).classList.add('completed');
            
            currentStep = step;
            
            // اگر step 3 باشد، نمایش خلاصه
            if (step === 3) {
                showSummary();
            }
        }
        
        function prevStep(step) {
            document.querySelectorAll('.form-step').forEach(el => el.classList.remove('active'));
            document.querySelectorAll('.step').forEach(el => el.classList.remove('active', 'completed'));
            
            document.querySelector(`.form-step[data-step="${step}"]`).classList.add('active');
            document.querySelector(`.step[data-step="${step}"]`).classList.add('active');
            
            for (let i = 1; i < step; i++) {
                document.querySelector(`.step[data-step="${i}"]`).classList.add('completed');
            }
            
            currentStep = step;
        }
        
        // اعتبارسنجی
        function validateStep(step) {
            const form = document.getElementById('registerForm');
            
            if (step === 1) {
                const email = form.email.value;
                const password = form.password.value;
                const passwordConfirm = form.password_confirm.value;
                
                if (!email || !password || !passwordConfirm) {
                    showError('لطفاً تمام فیلدها را پر کنید');
                    return false;
                }
                
                if (password.length < 8) {
                    showError('رمز عبور باید حداقل 8 کاراکتر باشد');
                    return false;
                }
                
                if (password !== passwordConfirm) {
                    showError('رمز عبور و تکرار آن یکسان نیستند');
                    return false;
                }
            }
            
            return true;
        }
        
        // نمایش خلاصه
        function showSummary() {
            const form = document.getElementById('registerForm');
            document.getElementById('confirmEmail').textContent = form.email.value;
            document.getElementById('confirmReferrer').textContent = form.referrer_id.value || 'seed';
            document.getElementById('confirmPhone').textContent = form.phone_number.value || '-';
        }
        
        // نمایش پیام
        function showError(message) {
            const el = document.getElementById('errorMessage');
            el.textContent = message;
            el.style.display = 'block';
            setTimeout(() => el.style.display = 'none', 5000);
        }
        
        function showSuccess(message) {
            const el = document.getElementById('successMessage');
            el.textContent = message;
            el.style.display = 'block';
        }
        
        // ثبت‌نام
        document.getElementById('registerForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            const data = {
                email: formData.get('email'),
                password: formData.get('password'),
                referrer_id: formData.get('referrer_id') || 'seed',
                phone_number: formData.get('phone_number')
            };
            
            const form = document.getElementById('registerForm');
            const loading = document.getElementById('loading');
            
            form.style.display = 'none';
            loading.style.display = 'block';
            
            try {
                const response = await fetch(`${API_BASE}/register`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                loading.style.display = 'none';
                
                if (result.success) {
                    showSuccess('ثبت‌نام موفق! در حال انتقال به صفحه پرداخت...');
                    
                    // ذخیره user_id
                    localStorage.setItem('user_id', result.user_id);
                    localStorage.setItem('referral_code', result.referral_code);
                    
                    // انتقال به صفحه پرداخت
                    setTimeout(() => {
                        window.location.href = '../dashboard/payment.php';
                    }, 2000);
                } else {
                    form.style.display = 'block';
                    showError(result.errors ? Object.values(result.errors).join(', ') : 'خطا در ثبت‌نام');
                }
                
            } catch (error) {
                loading.style.display = 'none';
                form.style.display = 'block';
                showError('خطا در ارتباط با سرور');
            }
        });
    </script>
</body>
</html>
