<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود - سیستم MLM</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            width: 100%;
            max-width: 450px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .header h1 {
            color: #2c3e50;
            font-size: 28px;
            margin-bottom: 10px;
        }
        
        .header p {
            color: #7f8c8d;
            font-size: 14px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #2c3e50;
            font-weight: 500;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .btn-login {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: transform 0.2s;
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
        }
        
        .btn-login:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .error-message {
            background: #f8d7da;
            color: #721c24;
            padding: 12px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
            display: none;
        }
        
        .register-link {
            text-align: center;
            margin-top: 20px;
            color: #7f8c8d;
        }
        
        .register-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
        }
        
        .loading {
            display: none;
            text-align: center;
            padding: 20px;
        }
        
        .spinner {
            border: 4px solid #f3f3f3;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .remember-me {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .remember-me input {
            width: auto;
            margin-left: 8px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔐 ورود به سیستم</h1>
            <p>به حساب کاربری خود وارد شوید</p>
        </div>
        
        <div id="errorMessage" class="error-message"></div>
        
        <form id="loginForm">
            <div class="form-group">
                <label>ایمیل:</label>
                <input type="email" name="email" required placeholder="example@email.com">
            </div>
            
            <div class="form-group">
                <label>رمز عبور:</label>
                <input type="password" name="password" required placeholder="رمز عبور خود را وارد کنید">
            </div>
            
            <div class="remember-me">
                <input type="checkbox" name="remember" id="remember">
                <label for="remember" style="margin: 0; font-weight: normal;">مرا به خاطر بسپار</label>
            </div>
            
            <button type="submit" class="btn-login">ورود</button>
        </form>
        
        <div class="loading" id="loading">
            <div class="spinner"></div>
            <p style="margin-top: 10px; color: #7f8c8d;">در حال ورود...</p>
        </div>
        
        <div class="register-link">
            حساب کاربری ندارید؟ <a href="register.php">ثبت‌نام</a>
        </div>
    </div>
    
    <script>
        const API_BASE = window.location.origin + '/api';
        
        document.getElementById('loginForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            const data = {
                email: formData.get('email'),
                password: formData.get('password')
            };
            
            const form = document.getElementById('loginForm');
            const loading = document.getElementById('loading');
            const errorMsg = document.getElementById('errorMessage');
            
            form.style.display = 'none';
            loading.style.display = 'block';
            errorMsg.style.display = 'none';
            
            try {
                const response = await fetch(`${API_BASE}/login`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                loading.style.display = 'none';
                
                if (result.success) {
                    // ذخیره اطلاعات
                    localStorage.setItem('user_id', result.user_id);
                    localStorage.setItem('email', result.email);
                    localStorage.setItem('token', result.token);
                    localStorage.setItem('status', result.status);
                    localStorage.setItem('role', result.role);
                    
                    // انتقال به dashboard یا admin
                    if (result.role === 'admin') {
                        window.location.href = '../../admin/index.php';
                    } else {
                        window.location.href = '../dashboard/index.php';
                    }
                } else {
                    form.style.display = 'block';
                    errorMsg.textContent = result.error || 'ایمیل یا رمز عبور اشتباه است';
                    errorMsg.style.display = 'block';
                }
                
            } catch (error) {
                loading.style.display = 'none';
                form.style.display = 'block';
                errorMsg.textContent = 'خطا در ارتباط با سرور';
                errorMsg.style.display = 'block';
            }
        });
    </script>
</body>
</html>
