#!/usr/bin/env php
<?php
/**
 * Background Worker - Process Queue Jobs
 * Run this with: php worker.php
 * Or as cron: */1 * * * * php /path/to/worker.php
 */

require_once __DIR__ . '/../includes/Database.php';
require_once __DIR__ . '/../includes/QueueService.php';
require_once __DIR__ . '/../includes/CacheService.php';

echo "MLM Worker Started - " . date('Y-m-d H:i:s') . "\n";

$queueService = new QueueService();
$cacheService = CacheService::getInstance();

// Process jobs
$batchSize = 50; // Process 50 jobs at a time
$maxIterations = 10; // Run max 10 iterations

for ($i = 0; $i < $maxIterations; $i++) {
    echo "\n=== Iteration " . ($i + 1) . " ===\n";
    
    $processed = $queueService->processPendingJobs($batchSize);
    
    echo "Processed {$processed} jobs\n";
    
    if ($processed === 0) {
        echo "No more jobs to process\n";
        break;
    }
    
    // Small delay to prevent overwhelming the database
    usleep(100000); // 0.1 second
}

// Clean old jobs (older than 7 days)
echo "\nCleaning old jobs...\n";
$queueService->cleanOldJobs(7);

// Show stats
$stats = $queueService->getStats();
echo "\n=== Queue Stats ===\n";
echo "Total: {$stats['total']}\n";
echo "Pending: {$stats['pending']}\n";
echo "Processing: {$stats['processing']}\n";
echo "Completed: {$stats['completed']}\n";
echo "Failed: {$stats['failed']}\n";

echo "\nWorker Finished - " . date('Y-m-d H:i:s') . "\n";
