<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) { header('Location: login.php'); exit(); }
require_once __DIR__ . '/../includes/Database.php';
require_once __DIR__ . '/../includes/WithdrawalService.php';

$db = Database::getInstance();
$withdrawalService = new WithdrawalService();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $withdrawalId = $_POST['withdrawal_id'] ?? '';
    
    if ($action === 'approve' && $withdrawalId) {
        $txHash = $_POST['tx_hash'] ?? null;
        $result = $withdrawalService->approveWithdrawal($withdrawalId, $txHash);
        $message = $result['success'] ? 'برداشت تایید شد' : 'خطا: ' . $result['error'];
    } elseif ($action === 'reject' && $withdrawalId) {
        $reason = $_POST['reason'] ?? 'رد شد';
        $result = $withdrawalService->rejectWithdrawal($withdrawalId, $reason);
        $message = $result['success'] ? 'برداشت رد شد' : 'خطا: ' . $result['error'];
    }
}

$pending = $withdrawalService->getPendingWithdrawals();
$stats = $withdrawalService->getWithdrawalStats();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مدیریت برداشت‌ها</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI'; background: #f5f7fa; direction: rtl; }
        .container { max-width: 1400px; margin: 0 auto; padding: 30px; }
        .stats { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 30px; }
        .stat-card { background: white; padding: 20px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .stat-card h3 { font-size: 14px; color: #7f8c8d; margin-bottom: 10px; }
        .stat-card .value { font-size: 28px; font-weight: bold; color: #2c3e50; }
        .card { background: white; padding: 25px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        table { width: 100%; border-collapse: collapse; }
        table th { background: #f8f9fa; padding: 12px; text-align: right; border-bottom: 2px solid #dee2e6; }
        table td { padding: 12px; border-bottom: 1px solid #dee2e6; font-size: 13px; }
        .btn { padding: 6px 12px; border: none; border-radius: 5px; cursor: pointer; font-size: 12px; margin: 2px; }
        .btn-success { background: #27ae60; color: white; }
        .btn-danger { background: #e74c3c; color: white; }
        h1 { margin-bottom: 20px; color: #2c3e50; }
        .message { padding: 15px; border-radius: 8px; margin-bottom: 20px; text-align: center; background: #d4edda; color: #155724; }
    </style>
</head>
<body>
    <div class="container">
        <?php if (isset($message)): ?>
        <div class="message"><?= $message ?></div>
        <?php endif; ?>
        
        <div class="stats">
            <div class="stat-card">
                <h3>کل درخواست‌ها</h3>
                <div class="value"><?= number_format($stats['total_requests']) ?></div>
            </div>
            <div class="stat-card">
                <h3>در انتظار</h3>
                <div class="value"><?= number_format($stats['pending_requests']) ?></div>
            </div>
            <div class="stat-card">
                <h3>تایید شده</h3>
                <div class="value"><?= number_format($stats['completed_requests']) ?></div>
            </div>
            <div class="stat-card">
                <h3>مجموع برداشت</h3>
                <div class="value">$<?= number_format($stats['total_withdrawn'], 2) ?></div>
            </div>
        </div>
        
        <div class="card">
            <h1>💸 برداشت‌های در انتظار تایید</h1>
            <?php if (count($pending) === 0): ?>
                <p style="text-align:center;padding:30px;color:#7f8c8d;">برداشت در انتظاری وجود ندارد</p>
            <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>شناسه</th>
                        <th>کاربر</th>
                        <th>مبلغ</th>
                        <th>کارمزد</th>
                        <th>خالص</th>
                        <th>کیف پول</th>
                        <th>شبکه</th>
                        <th>تاریخ</th>
                        <th>عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pending as $w): ?>
                    <tr>
                        <td><?= htmlspecialchars($w['withdrawal_id']) ?></td>
                        <td><?= htmlspecialchars($w['email']) ?></td>
                        <td>$<?= number_format($w['amount'], 2) ?></td>
                        <td>$<?= number_format($w['fee'], 2) ?></td>
                        <td>$<?= number_format($w['net_amount'], 2) ?></td>
                        <td><code style="font-size:11px;"><?= substr($w['wallet_address'], 0, 20) ?>...</code></td>
                        <td><?= $w['network'] ?></td>
                        <td><?= date('Y-m-d H:i', strtotime($w['created_at'])) ?></td>
                        <td>
                            <form method="POST" style="display:inline;">
                                <input type="hidden" name="withdrawal_id" value="<?= $w['withdrawal_id'] ?>">
                                <input type="hidden" name="action" value="approve">
                                <input type="text" name="tx_hash" placeholder="TX Hash (optional)" style="font-size:11px;padding:4px;margin:2px;">
                                <button type="submit" class="btn btn-success" onclick="return confirm('تایید برداشت؟')">تایید</button>
                            </form>
                            <form method="POST" style="display:inline;">
                                <input type="hidden" name="withdrawal_id" value="<?= $w['withdrawal_id'] ?>">
                                <input type="hidden" name="action" value="reject">
                                <input type="text" name="reason" placeholder="دلیل رد" style="font-size:11px;padding:4px;margin:2px;">
                                <button type="submit" class="btn btn-danger" onclick="return confirm('رد برداشت؟')">رد</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
