<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) { header('Location: login.php'); exit(); }
require_once __DIR__ . '/../includes/Database.php';
$db = Database::getInstance();
$users = $db->fetchAll("SELECT * FROM users WHERE user_id != 'seed' ORDER BY created_at DESC LIMIT 100");
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مدیریت کاربران</title>
    <link rel="stylesheet" href="index.php" style="display:none;">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI'; background: #f5f7fa; direction: rtl; }
        .container { max-width: 1400px; margin: 0 auto; padding: 30px; }
        .card { background: white; padding: 25px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        table { width: 100%; border-collapse: collapse; }
        table th { background: #f8f9fa; padding: 12px; text-align: right; border-bottom: 2px solid #dee2e6; }
        table td { padding: 12px; border-bottom: 1px solid #dee2e6; font-size: 13px; }
        .badge { padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; }
        .badge.success { background: #d4edda; color: #155724; }
        .badge.warning { background: #fff3cd; color: #856404; }
        .btn { padding: 6px 12px; border: none; border-radius: 5px; cursor: pointer; font-size: 12px; text-decoration: none; }
        .btn-primary { background: #3498db; color: white; }
        h1 { margin-bottom: 20px; color: #2c3e50; }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h1>👥 مدیریت کاربران</h1>
            <table>
                <thead>
                    <tr>
                        <th>شناسه</th>
                        <th>ایمیل</th>
                        <th>معرف</th>
                        <th>وضعیت</th>
                        <th>موجودی</th>
                        <th>زیرمجموعه</th>
                        <th>تاریخ عضویت</th>
                        <th>عملیات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?= htmlspecialchars($user['user_id']) ?></td>
                        <td><?= htmlspecialchars($user['email']) ?></td>
                        <td><?= htmlspecialchars($user['referrer_id']) ?></td>
                        <td><span class="badge <?= $user['status'] === 'active' ? 'success' : 'warning' ?>"><?= $user['status'] ?></span></td>
                        <td>$<?= number_format($user['total_points'], 2) ?></td>
                        <td><?= $user['total_descendants'] ?></td>
                        <td><?= date('Y-m-d', strtotime($user['created_at'])) ?></td>
                        <td><a href="user_detail.php?id=<?= $user['user_id'] ?>" class="btn btn-primary">جزئیات</a></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
