<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل مدیریت - MLM System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f5f7fa;
            direction: rtl;
        }
        
        .container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 250px;
            background: #2c3e50;
            color: white;
            padding: 20px 0;
        }
        
        .sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid #34495e;
        }
        
        .sidebar-header h2 {
            font-size: 20px;
            color: #ecf0f1;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .sidebar-menu li {
            margin: 5px 0;
        }
        
        .sidebar-menu a {
            display: block;
            padding: 12px 20px;
            color: #ecf0f1;
            text-decoration: none;
            transition: background 0.3s;
        }
        
        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: #34495e;
        }
        
        /* Main Content */
        .main-content {
            flex: 1;
            padding: 30px;
        }
        
        .header {
            background: white;
            padding: 20px 30px;
            border-radius: 10px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            color: #2c3e50;
            font-size: 24px;
        }
        
        .user-info {
            color: #7f8c8d;
        }
        
        /* Stats Cards */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .stat-card h3 {
            color: #7f8c8d;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        .stat-card .value {
            font-size: 32px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 5px;
        }
        
        .stat-card .change {
            font-size: 12px;
            color: #27ae60;
        }
        
        .stat-card.blue { border-right: 4px solid #3498db; }
        .stat-card.green { border-right: 4px solid #27ae60; }
        .stat-card.orange { border-right: 4px solid #e67e22; }
        .stat-card.red { border-right: 4px solid #e74c3c; }
        
        /* Table */
        .card {
            background: white;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        
        .card h2 {
            color: #2c3e50;
            margin-bottom: 20px;
            font-size: 18px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table th {
            background: #f8f9fa;
            padding: 12px;
            text-align: right;
            font-weight: 600;
            color: #2c3e50;
            border-bottom: 2px solid #dee2e6;
        }
        
        table td {
            padding: 12px;
            border-bottom: 1px solid #dee2e6;
        }
        
        .badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .badge.success { background: #d4edda; color: #155724; }
        .badge.warning { background: #fff3cd; color: #856404; }
        .badge.danger { background: #f8d7da; color: #721c24; }
        
        .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-primary { background: #3498db; color: white; }
        .btn-success { background: #27ae60; color: white; }
        .btn-danger { background: #e74c3c; color: white; }
        
        .btn:hover {
            opacity: 0.9;
        }
    </style>
</head>
<body>
    <?php
    session_start();
    require_once __DIR__ . '/../includes/Database.php';
    require_once __DIR__ . '/../includes/UserService.php';
    require_once __DIR__ . '/../includes/PaymentService.php';
    require_once __DIR__ . '/../includes/WithdrawalService.php';
    
    // بررسی ورود ادمین
    if (!isset($_SESSION['admin_logged_in'])) {
        header('Location: login.php');
        exit();
    }
    
    $db = Database::getInstance();
    $paymentService = new PaymentService();
    $withdrawalService = new WithdrawalService();
    
    // دریافت آمار کلی
    $totalUsers = $db->fetchOne("SELECT COUNT(*) as count FROM users WHERE user_id != 'seed'")['count'];
    $activeUsers = $db->fetchOne("SELECT COUNT(*) as count FROM users WHERE status = 'active' AND user_id != 'seed'")['count'];
    $pendingUsers = $db->fetchOne("SELECT COUNT(*) as count FROM users WHERE status = 'pending'")['count'];
    
    $paymentStats = $paymentService->getPaymentStats();
    $withdrawalStats = $withdrawalService->getWithdrawalStats();
    
    $totalRevenue = $db->fetchOne("SELECT SUM(amount) as total FROM payments WHERE status = 'confirmed'")['total'] ?? 0;
    
    // آخرین فعال‌سازی‌ها
    $recentActivations = $db->fetchAll(
        "SELECT user_id, email, activated_at 
         FROM users 
         WHERE status = 'active' 
         ORDER BY activated_at DESC 
         LIMIT 10"
    );
    
    // برداشت‌های pending
    $pendingWithdrawals = $withdrawalService->getPendingWithdrawals();
    ?>
    
    <div class="container">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>🎯 پنل مدیریت</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="index.php" class="active">📊 داشبورد</a></li>
                <li><a href="users.php">👥 کاربران</a></li>
                <li><a href="manage_users.php">🔧 مدیریت و فعال‌سازی</a></li>
                <li><a href="payments.php">💳 پرداخت‌ها</a></li>
                <li><a href="withdrawals.php">💸 برداشت‌ها</a></li>
                <li><a href="transactions.php">📝 تراکنش‌ها</a></li>
                <li><a href="settings.php">⚙️ تنظیمات</a></li>
                <li><a href="logout.php">🚪 خروج</a></li>
            </ul>
        </div>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Header -->
            <div class="header">
                <h1>📊 داشبورد</h1>
                <div class="user-info">
                    مدیر سیستم | <?php echo date('Y-m-d H:i'); ?>
                </div>
            </div>
            
            <!-- Stats Cards -->
            <div class="stats-grid">
                <div class="stat-card blue">
                    <h3>کل کاربران</h3>
                    <div class="value"><?php echo number_format($totalUsers); ?></div>
                    <div class="change">فعال: <?php echo number_format($activeUsers); ?></div>
                </div>
                
                <div class="stat-card green">
                    <h3>کل درآمد</h3>
                    <div class="value">$<?php echo number_format($totalRevenue, 2); ?></div>
                    <div class="change">از پرداخت‌های تایید شده</div>
                </div>
                
                <div class="stat-card orange">
                    <h3>پرداخت‌های معلق</h3>
                    <div class="value"><?php echo number_format($paymentStats['pending_payments']); ?></div>
                    <div class="change">نیاز به بررسی</div>
                </div>
                
                <div class="stat-card red">
                    <h3>برداشت‌های معلق</h3>
                    <div class="value"><?php echo number_format($withdrawalStats['pending_requests']); ?></div>
                    <div class="change">نیاز به تایید</div>
                </div>
            </div>
            
            <!-- Recent Activations -->
            <div class="card">
                <h2>🎉 آخرین فعال‌سازی‌ها</h2>
                <table>
                    <thead>
                        <tr>
                            <th>شناسه کاربر</th>
                            <th>ایمیل</th>
                            <th>تاریخ فعال‌سازی</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recentActivations as $user): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($user['user_id']); ?></td>
                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                            <td><?php echo $user['activated_at']; ?></td>
                            <td>
                                <a href="user_detail.php?id=<?php echo $user['user_id']; ?>" class="btn btn-primary">مشاهده</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pending Withdrawals -->
            <?php if (count($pendingWithdrawals) > 0): ?>
            <div class="card">
                <h2>💸 برداشت‌های در انتظار تایید</h2>
                <table>
                    <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>کاربر</th>
                            <th>مبلغ</th>
                            <th>آدرس کیف پول</th>
                            <th>تاریخ</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pendingWithdrawals as $w): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($w['withdrawal_id']); ?></td>
                            <td><?php echo htmlspecialchars($w['email']); ?></td>
                            <td>$<?php echo number_format($w['amount'], 2); ?></td>
                            <td><code><?php echo substr($w['wallet_address'], 0, 20); ?>...</code></td>
                            <td><?php echo $w['created_at']; ?></td>
                            <td>
                                <a href="withdrawal_approve.php?id=<?php echo $w['withdrawal_id']; ?>" class="btn btn-success">تایید</a>
                                <a href="withdrawal_reject.php?id=<?php echo $w['withdrawal_id']; ?>" class="btn btn-danger">رد</a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
