# 📘 دستورالعمل نصب سیستم MLM روی cPanel

## پیش‌نیازها
- ✅ cPanel hosting با PHP 7.4+ و MySQL 5.7+
- ✅ دسترسی به phpMyAdmin
- ✅ دسترسی به Cron Jobs در cPanel
- ✅ حداقل 100MB فضای دیسک
- ✅ حداقل 256MB PHP Memory Limit

---

## مرحله 1️⃣: آپلود فایل‌ها

### 1.1. ورود به cPanel File Manager
1. وارد cPanel شوید
2. روی **File Manager** کلیک کنید
3. وارد پوشه `public_html` شوید

### 1.2. آپلود فایل‌های سیستم
یکی از دو روش زیر را انتخاب کنید:

**روش A: آپلود ZIP**
1. فایل‌های پروژه را Zip کنید
2. در File Manager روی **Upload** کلیک کنید
3. فایل ZIP را آپلود کنید
4. سپس راست کلیک روی فایل ZIP → **Extract**

**روش B: آپلود با FTP**
1. از نرم‌افزار FileZilla استفاده کنید
2. اطلاعات FTP را از cPanel دریافت کنید
3. تمام پوشه‌ها را آپلود کنید

### 1.3. ساختار نهایی
```
public_html/
├── api/
│   └── index.php
├── config/
│   └── database.php
├── includes/
│   ├── Database.php
│   ├── TreeService.php
│   ├── RewardService.php
│   └── UserService.php
├── cron/
│   └── process_rewards.php
├── database/
│   └── schema.sql
├── logs/
│   └── (empty - will be created automatically)
├── .htaccess
└── README_INSTALL.md (این فایل)
```

---

## مرحله 2️⃣: ساخت دیتابیس

### 2.1. ساخت Database در cPanel
1. در cPanel وارد **MySQL® Databases** شوید
2. در بخش **Create New Database**:
   - نام دیتابیس: `mlm_production` (یا هر نام دلخواهی)
   - روی **Create Database** کلیک کنید

### 2.2. ساخت User برای دیتابیس
1. در همان صفحه، بخش **MySQL Users**:
   - نام کاربری: دلخواه (مثلاً `mlm_user`)
   - رمز عبور قوی بسازید
   - روی **Create User** کلیک کنید

### 2.3. اختصاص User به Database
1. در بخش **Add User To Database**:
   - User را انتخاب کنید
   - Database را انتخاب کنید
   - روی **Add** کلیک کنید
2. تمام Privileges را انتخاب کنید → **Make Changes**

### 2.4. اجرای Schema
1. در cPanel وارد **phpMyAdmin** شوید
2. دیتابیس `mlm_production` را انتخاب کنید
3. روی تب **SQL** کلیک کنید
4. محتویات فایل `database/schema.sql` را کپی کنید
5. در textarea قرار دهید و **Go** بزنید

✅ **نتیجه:** باید 8 جدول ساخته شود + داده‌های پیش‌فرض

---

## مرحله 3️⃣: تنظیم اتصال به دیتابیس

### 3.1. ویرایش فایل config
1. در File Manager فایل `config/database.php` را باز کنید
2. اطلاعات را تغییر دهید:

```php
return [
    'host' => 'localhost',              // معمولاً localhost
    'dbname' => 'cpanel_mlm_production', // نام دیتابیس با prefix cPanel
    'username' => 'cpanel_mlm_user',     // نام کاربری با prefix
    'password' => 'YOUR_STRONG_PASSWORD', // رمز عبوری که ساختید
    'charset' => 'utf8mb4',
];
```

⚠️ **توجه:** cPanel معمولاً prefix اکانت شما را به نام database و user اضافه می‌کند.
مثلاً اگر اکانت شما `myaccount` باشد:
- Database: `myaccount_mlm_production`
- User: `myaccount_mlm_user`

### 3.2. تست اتصال
یک فایل `test_connection.php` بسازید:

```php
<?php
require_once 'includes/Database.php';

try {
    $db = Database::getInstance();
    echo "✅ اتصال به دیتابیس موفق بود!";
} catch (Exception $e) {
    echo "❌ خطا: " . $e->getMessage();
}
?>
```

سپس از مرورگر باز کنید: `http://yourdomain.com/test_connection.php`

---

## مرحله 4️⃣: تنظیم Cron Job

### 4.1. افزودن Cron Job در cPanel
1. در cPanel وارد **Cron Jobs** شوید
2. در بخش **Add New Cron Job**:

**تنظیمات:**
- **Common Settings:** هر 5 دقیقه یک بار
- یا **Minute:** `*/5` (هر 5 دقیقه)
- **Hour:** `*`
- **Day:** `*`
- **Month:** `*`
- **Weekday:** `*`

**Command:**
```bash
/usr/bin/php /home/USERNAME/public_html/cron/process_rewards.php
```

⚠️ **توجه:** `USERNAME` را با نام کاربری cPanel خود جایگزین کنید

### 4.2. تست Cron Job
دستور را یک بار دستی اجرا کنید (از SSH یا cPanel Terminal):

```bash
/usr/bin/php /home/USERNAME/public_html/cron/process_rewards.php
```

اگر موفق باشد، فایل log در `logs/cron_rewards.log` ساخته می‌شود.

---

## مرحله 5️⃣: تنظیمات امنیتی

### 5.1. تنظیم Permissions
در File Manager روی هر پوشه راست کلیک → **Permissions**:

```
public_html/              : 755
api/                      : 755
config/                   : 750  (⚠️ مهم)
includes/                 : 750  (⚠️ مهم)
cron/                     : 750
logs/                     : 755  (قابل نوشتن)
.htaccess                 : 644
```

### 5.2. محافظت از فایل‌های حساس
فایل `.htaccess` موجود قبلاً این کار را انجام می‌دهد، ولی بررسی کنید:
- پوشه `config/` نباید از مرورگر قابل دسترسی باشد
- پوشه `includes/` نباید از مرورگر قابل دسترسی باشد

### 5.3. حذف فایل تست
فایل `test_connection.php` را حذف کنید یا نام آن را تغییر دهید.

---

## مرحله 6️⃣: تست API

### 6.1. تست endpoint ثبت‌نام
از Postman یا curl تست کنید:

```bash
curl -X POST http://yourdomain.com/api/register \
  -H "Content-Type: application/json" \
  -d '{
    "email": "test@example.com",
    "password": "Test123456",
    "phone_number": "09123456789",
    "referrer_id": "seed"
  }'
```

**پاسخ موفق:**
```json
{
  "success": true,
  "user_id": "USR_...",
  "referral_code": "ABC123...",
  "message": "Registration successful..."
}
```

### 6.2. تست endpoint login
```bash
curl -X POST http://yourdomain.com/api/login \
  -H "Content-Type: application/json" \
  -d '{
    "email": "test@example.com",
    "password": "Test123456"
  }'
```

### 6.3. تست سایر endpointها
- `GET /api/user/{user_id}` - اطلاعات کاربر
- `GET /api/tree/{user_id}` - درخت MLM
- `GET /api/tree-stats/{user_id}` - آمار درخت
- `GET /api/reward-stats/{user_id}` - آمار پاداش
- `GET /api/transactions/{user_id}` - تراکنش‌ها

---

## مرحله 7️⃣: نصب Frontend (React)

### 7.1. Build کردن React
روی سیستم محلی:

```bash
cd frontend
npm install
npm run build
```

### 7.2. آپلود Build
پوشه `build` را به یکی از دو روش آپلود کنید:

**روش A:** در پوشه `public_html` (با backend)
```
public_html/
├── api/           (backend)
├── static/        (React static files)
├── index.html     (React entry)
└── ...
```

**روش B:** در subdomain جداگانه (توصیه می‌شود)
```
frontend.yourdomain.com/
├── static/
├── index.html
└── ...
```

### 7.3. تنظیم API URL
در فایل `.env` یا تنظیمات React:
```
REACT_APP_API_URL=https://yourdomain.com/api
```

---

## مرحله 8️⃣: مانیتورینگ و نگهداری

### 8.1. بررسی Logs
فایل‌های log در پوشه `logs/`:
- `database_errors.log` - خطاهای دیتابیس
- `cron_rewards.log` - اجرای Cron Job

### 8.2. Backup دیتابیس
در cPanel از **phpMyAdmin** → **Export** استفاده کنید.
**توصیه:** هر روز یک نسخه پشتیبان بگیرید.

### 8.3. بررسی Performance
- تعداد کاربران فعال
- تعداد تراکنش‌های pending
- زمان اجرای Cron Job

---

## عیب‌یابی رایج

### مشکل 1: Error 500 در API
**علت:** خطا در کد PHP یا تنظیمات
**راه‌حل:**
1. در `.htaccess` فعال کنید:
   ```apache
   php_flag display_errors On
   ```
2. خطا را ببینید و برطرف کنید
3. بعد از حل، `display_errors` را Off کنید

### مشکل 2: Cron Job اجرا نمی‌شود
**علت:** مسیر PHP یا فایل اشتباه است
**راه‌حل:**
1. مسیر PHP را پیدا کنید:
   ```bash
   which php
   ```
2. مسیر صحیح را در Cron Command استفاده کنید

### مشکل 3: پاداش‌ها توزیع نمی‌شوند
**علت:** Cron Job اجرا نشده یا خطا در محاسبات
**راه‌حل:**
1. فایل `logs/cron_rewards.log` را بررسی کنید
2. جدول `reward_events` را چک کنید:
   ```sql
   SELECT * FROM reward_events WHERE status = 'pending';
   ```

### مشکل 4: درخت نادرست ساخته می‌شود
**علت:** Trigger یا BFS مشکل دارد
**راه‌حل:**
1. بررسی کنید Triggerها نصب شده‌اند:
   ```sql
   SHOW TRIGGERS;
   ```
2. دستی یک کاربر فعال کنید و جدول users را چک کنید

---

## 🎯 چک‌لیست نهایی

قبل از Production:

- [ ] دیتابیس ساخته شد و schema اجرا شد
- [ ] فایل `config/database.php` تنظیم شد
- [ ] تست اتصال به دیتابیس موفق بود
- [ ] Cron Job تنظیم و تست شد
- [ ] Permissions فایل‌ها صحیح است
- [ ] `.htaccess` فعال است و routing کار می‌کند
- [ ] API endpoints تست شدند
- [ ] کاربر seed (admin) وجود دارد
- [ ] ثبت‌نام و فعال‌سازی تست شد
- [ ] توزیع پاداش کار می‌کند
- [ ] Frontend build شد و آپلود شد
- [ ] Backup دیتابیس گرفته شد
- [ ] در Production: `display_errors` خاموش شد
- [ ] SSL نصب شد (HTTPS)

---

## 📞 پشتیبانی

اگر مشکلی پیش آمد:
1. فایل‌های log را بررسی کنید
2. جدول `audit_logs` را چک کنید
3. از Postman API را تست کنید
4. مستندات را مجدد بخوانید

**نکته:** برای Production، حتماً:
- رمزهای قوی استفاده کنید
- SSL نصب کنید
- Backup منظم بگیرید
- Monitoring فعال کنید

---

✅ **سیستم آماده است!**

برای ورود به پنل admin:
- Email: `admin@mlm.local`
- Password: `password` (⚠️ حتماً تغییر دهید)
