# 📘 راهنمای نصب در cPanel - گام به گام

## ✅ **نیازمندی‌ها:**
- cPanel Hosting
- PHP 7.4+
- MySQL 5.7+
- حداقل 512MB RAM

**نیاز به SSH ندارید!** ✅

---

## 🚀 **مرحله 1: آپلود فایل‌ها (5 دقیقه)**

### **روش آسان:**

1. برو **cPanel → File Manager**
2. رفتن به `public_html`
3. کلیک روی **Upload**
4. انتخاب فایل `mlm_cpanel_final.zip`
5. صبر کن تا آپلود بشه
6. برگرد به File Manager
7. راست کلیک روی ZIP → **Extract**
8. بعد از Extract، **همه فایل‌ها** رو از پوشه `mlm_cpanel_final` ببر بیرون به `public_html`

**نتیجه:** فایل‌ها باید **مستقیم** در `public_html` باشن، نه توی پوشه!

```
✅ درست:
public_html/
  ├── api/
  ├── includes/
  ├── pages/
  └── ...

❌ اشتباه:
public_html/
  └── mlm_cpanel_final/
      ├── api/
      └── ...
```

---

## 🗄️ **مرحله 2: ساخت دیتابیس (3 دقیقه)**

### **2.1: ساخت Database:**
1. برو **cPanel → MySQL Databases**
2. قسمت **"Create New Database"**
3. اسم بذار: `mlm_db` (یا هر اسمی)
4. **Create Database** بزن
5. اسم کامل رو یادداشت کن (مثلاً `username_mlm_db`)

### **2.2: ساخت User:**
1. همون صفحه، قسمت **"Add New User"**
2. Username: `mlm_user`
3. Password: یک رمز قوی بساز و یادداشت کن
4. **Create User** بزن

### **2.3: اضافه کردن User به Database:**
1. همون صفحه، پایین‌تر قسمت **"Add User To Database"**
2. انتخاب User: `mlm_user`
3. انتخاب Database: `mlm_db`
4. **Add** بزن
5. صفحه بعدی: **ALL PRIVILEGES** رو تیک بزن
6. **Make Changes** بزن

---

## 📥 **مرحله 3: Import دیتابیس (2 دقیقه)**

1. برو **cPanel → phpMyAdmin**
2. از لیست چپ، database خودت رو انتخاب کن (`username_mlm_db`)
3. بالا تب **Import** رو بزن
4. **Choose File** بزن
5. از کامپیوترت فایل `database/schema.sql` رو انتخاب کن
6. پایین صفحه **Go** بزن
7. صبر کن (چند ثانیه)
8. باید پیغام سبز **"Import has been successfully finished"** ببینی

**چک کردن:**
- از لیست چپ، باید 10 تا جدول ببینی
- کلیک روی جدول `users` → باید 2 رکورد داشته باشه (seed و admin)

---

## ⚙️ **مرحله 4: تنظیم Database (1 دقیقه)**

1. برو **cPanel → File Manager**
2. باز کن `config/database.php`
3. کلیک راست → **Edit**
4. این 4 خط رو ویرایش کن:

```php
'host' => 'localhost',              // همین رو نگه دار
'database' => 'username_mlm_db',    // اسم database از مرحله 2.1
'username' => 'username_mlm_user',  // اسم user از مرحله 2.2
'password' => 'YOUR_PASSWORD',      // رمزی که در مرحله 2.2 ساختی
```

5. **Save Changes** بزن

---

## ✅ **مرحله 5: تست سیستم (2 دقیقه)**

### **5.1: تست ساده:**
برو به:
```
https://yourdomain.com/check_seed.php
```

باید ببینی:
```
✅ کاربر seed وجود دارد
Email: seed@system.local
Status: active
```

### **5.2: تست ادمین:**
برو به:
```
https://yourdomain.com/admin/login.php
```

ورود:
- Email: `admin@mlm.local`
- Password: `password`

اگه داشبورد باز شد → **موفق!** ✅

---

## 🔧 **مرحله 6: Cron Job (2 دقیقه)**

برای پردازش خودکار پاداش‌ها و Queue:

1. برو **cPanel → Cron Jobs**
2. قسمت **"Add New Cron Job"**
3. تنظیمات:

```
Minute: */5
Hour: *
Day: *
Month: *
Weekday: *

Command: php /home/USERNAME/public_html/cron/worker.php
```

**نکته:** `USERNAME` رو با username واقعی cPanel جایگزین کن!

4. **Add New Cron Job** بزن

**این Cron هر 5 دقیقه یکبار اجرا میشه.**

---

## 🎯 **مرحله 7: تنظیمات نهایی (5 دقیقه)**

### **7.1: تغییر رمز ادمین:**
برو **phpMyAdmin**:
```sql
-- ساخت رمز جدید
UPDATE users 
SET password_hash = '$2y$10$YOUR_NEW_HASH_HERE' 
WHERE email = 'admin@mlm.local';
```

یا از این سایت hash بساز:
https://bcrypt-generator.com/

### **7.2: تنظیم Wallet Address:**
برو **admin panel → Settings**:
- System Wallet Address: آدرس BSC کیف پول خودت

### **7.3: تنظیم Email (اختیاری):**
برو **phpMyAdmin → جدول settings**:

```sql
UPDATE settings SET setting_value = 'smtp.gmail.com' WHERE setting_key = 'email.smtpHost';
UPDATE settings SET setting_value = '587' WHERE setting_key = 'email.smtpPort';
UPDATE settings SET setting_value = 'your@email.com' WHERE setting_key = 'email.smtpUsername';
UPDATE settings SET setting_value = 'your_password' WHERE setting_key = 'email.smtpPassword';
```

---

## 🧪 **مرحله 8: تست کامل (10 دقیقه)**

### **8.1: تست ثبت‌نام:**
```
https://yourdomain.com/pages/auth/register.php
```
یک حساب تستی بساز

### **8.2: تست ادمین:**
برو به:
```
https://yourdomain.com/admin/test_register.php
```
ثبت‌نام 10 کاربر تستی و بررسی درخت

### **8.3: تست پرداخت:**
یک پرداخت تستی روی Testnet انجام بده

---

## ✅ **چک‌لیست نهایی:**

- [ ] فایل‌ها در `public_html` هستن (نه توی پوشه)
- [ ] Database ساخته شد
- [ ] User به database اضافه شد
- [ ] Schema import شد (10 جدول)
- [ ] `config/database.php` تنظیم شد
- [ ] `check_seed.php` موفق بود
- [ ] Admin login کار می‌کنه
- [ ] Cron job ساخته شد
- [ ] Wallet address تنظیم شد
- [ ] تست ثبت‌نام موفق بود

---

## 🆘 **مشکلات رایج:**

### **1. خطای 500:**
```
راه‌حل:
1. چک کن config/database.php
2. چک کن Permissions (755 برای folders, 644 برای files)
3. Rename کن .htaccess به .htaccess.old
```

### **2. Database Connection Failed:**
```
راه‌حل:
1. چک کن اسم database دقیقاً درسته
2. چک کن username و password
3. توی cPanel → MySQL Databases بررسی کن user به database اضافه شده
```

### **3. صفحه خالی:**
```
راه‌حل:
1. برو cPanel → Error Log
2. آخرین خطا رو ببین
3. PHP Version رو چک کن (باید 7.4+)
```

### **4. Cron کار نمی‌کنه:**
```
راه‌حل:
1. Path رو چک کن: /home/USERNAME/public_html/...
2. بررسی کن PHP path: which php
3. تست دستی: php /full/path/to/worker.php
```

---

## 📞 **پشتیبانی:**

اگه مشکلی داشتی:
1. چک کن `Error Log` در cPanel
2. تست کن `check_seed.php`
3. بررسی کن فایل‌ها در جای درست باشن
4. مطمئن شو PHP 7.4+ هست

---

## 🎉 **تمام!**

حالا سیستم MLM تو **کاملاً** آماده است:
- ✅ بدون نیاز به SSH
- ✅ همه چیز از cPanel
- ✅ آماده برای 100,000+ کاربر
- ✅ Cron job خودکار

**موفق باشی!** 🚀

---

**نکات مهم:**
- همیشه Backup بگیر
- رمز ادمین رو عوض کن
- فایل‌های تست (`check_*.php`) رو بعداً پاک کن
- SSL فعال کن (Let's Encrypt رایگان)
