# 🚀 سیستم MLM - راهنمای نصب کامل (فارسی)

## 📖 فهرست مطالب

1. [معرفی](#معرفی)
2. [پیش‌نیازها](#پیش‌نیازها)
3. [روش‌های نصب](#روش‌های-نصب)
4. [مدیریت سیستم](#مدیریت-سیستم)
5. [عیب‌یابی](#عیب‌یابی)
6. [بهینه‌سازی](#بهینه‌سازی)

---

## 🎯 معرفی

این سیستم MLM با **نصب کاملاً خودکار** طراحی شده که:

✅ تمام وابستگی‌ها را خودکار نصب می‌کند  
✅ بدون نیاز به دستور دستی SSH  
✅ بعد از Reboot خودکار راه‌اندازی می‌شود  
✅ Nginx را به صورت خودکار پیکربندی می‌کند  
✅ PM2 یا Docker برای مدیریت سرویس‌ها  
✅ Production-Ready است  

---

## 💻 پیش‌نیازها

### سیستم‌عامل:
- Ubuntu 18.04 یا بالاتر
- Debian 10 یا بالاتر  
- CentOS 7 یا بالاتر
- Rocky Linux

### سخت‌افزار:
- RAM: حداقل 2GB (توصیه می‌شود 4GB)
- دیسک: حداقل 5GB فضای خالی
- CPU: 1 Core (توصیه می‌شود 2 Core)

### دسترسی:
- دسترسی Root یا Sudo
- اتصال به اینترنت

**نکته:** همه چیز دیگر (Docker, MongoDB, Redis, Node.js, etc.) خودکار نصب می‌شود!

---

## 🛠️ روش‌های نصب

دو روش برای نصب وجود دارد:

### 🐳 روش 1: Docker Compose (توصیه می‌شود)

این روش **سریع‌تر، ایزوله‌تر و قابل اطمینان‌تر** است.

```bash
# 1. دانلود و استخراج
unzip mlm_system.zip
cd mlm_system

# 2. اجرای اسکریپت نصب Docker
chmod +x docker-deploy.sh
sudo ./docker-deploy.sh
```

**تمام! سیستم آماده است.**

---

### ⚡ روش 2: نصب Native با PM2

اگر نمی‌خواهید از Docker استفاده کنید:

```bash
# 1. دانلود و استخراج
unzip mlm_system.zip
cd mlm_system

# 2. اجرای اسکریپت نصب خودکار
chmod +x auto-install.sh
sudo ./auto-install.sh
```

**زمان نصب: 5-10 دقیقه**

این اسکریپت موارد زیر را نصب می‌کند:
- ✅ Docker و Docker Compose
- ✅ MongoDB (در Docker)
- ✅ Redis (در Docker)
- ✅ Node.js 18 & Yarn
- ✅ PM2 Process Manager
- ✅ Python Virtual Environment
- ✅ Nginx Reverse Proxy
- ✅ تمام وابستگی‌های Backend و Frontend
- ✅ Build کردن Frontend
- ✅ اعمال Database Indexes

---

## 🔐 اطلاعات ورود

بعد از نصب، می‌توانید با اطلاعات زیر وارد شوید:

```
ایمیل:    admin@mlm.com
رمز عبور:  admin123
```

⚠️ **مهم:** حتماً بعد از اولین ورود، رمز عبور را تغییر دهید!

---

## 🌐 دسترسی به سیستم

بعد از نصب موفقیت‌آمیز:

```
🌍 آدرس: http://IP_SERVER_SHOMA
📱 Local: http://localhost
```

### چک کردن سلامت سیستم:

```bash
curl http://localhost/health
```

انتظار:
```json
{
  "status": "ok",
  "mongodb": true,
  "seed_user": true
}
```

---

## 🛠️ مدیریت سیستم

### اگر از Docker Compose استفاده کردید:

```bash
# مشاهده وضعیت سرویس‌ها
sudo docker compose ps

# مشاهده لاگ‌ها
sudo docker compose logs -f backend
sudo docker compose logs -f frontend

# ریستارت سرویس‌ها
sudo docker compose restart backend
sudo docker compose restart frontend

# توقف کامل سیستم
sudo docker compose down

# شروع سیستم
sudo docker compose up -d

# حذف کامل (داده‌ها حذف می‌شوند!)
sudo docker compose down -v
```

---

### اگر از PM2 استفاده کردید:

```bash
# مشاهده وضعیت
pm2 list

# مشاهده لاگ‌ها
pm2 logs mlm-backend
pm2 logs mlm-frontend

# ریستارت سرویس‌ها
pm2 restart mlm-backend
pm2 restart mlm-frontend
pm2 restart all

# توقف
pm2 stop mlm-backend
pm2 stop mlm-frontend
pm2 stop all

# شروع
pm2 start mlm-backend
pm2 start mlm-frontend
pm2 start all

# حذف کامل
pm2 delete all
```

---

### مدیریت Nginx:

```bash
# بررسی وضعیت
sudo systemctl status nginx

# ریستارت
sudo systemctl restart nginx

# توقف
sudo systemctl stop nginx

# شروع
sudo systemctl start nginx

# تست configuration
sudo nginx -t

# مشاهده لاگ‌ها
sudo tail -f /var/log/nginx/access.log
sudo tail -f /var/log/nginx/error.log
```

---

### مدیریت MongoDB:

```bash
# دسترسی به MongoDB Shell
sudo docker exec -it mlm-mongodb mongosh

# مشاهده لاگ‌ها
sudo docker logs mlm-mongodb -f

# ریستارت
sudo docker restart mlm-mongodb

# Backup
sudo docker exec mlm-mongodb mongodump --out /data/backup

# دریافت Backup
sudo docker cp mlm-mongodb:/data/backup ./mongodb_backup
```

---

## 🐛 عیب‌یابی

### مشکل 1: Backend راه‌اندازی نمی‌شود

```bash
# چک کردن logs
pm2 logs mlm-backend --lines 50
# یا
sudo docker compose logs backend

# چک کردن MongoDB
sudo docker exec mlm-mongodb mongosh --eval "db.version()"

# ریستارت Backend
pm2 restart mlm-backend
# یا
sudo docker compose restart backend
```

---

### مشکل 2: Frontend نمایش داده نمی‌شود

```bash
# چک Nginx
sudo nginx -t
sudo systemctl status nginx

# چک Frontend logs
pm2 logs mlm-frontend
# یا
sudo docker compose logs frontend

# ریستارت Nginx
sudo systemctl restart nginx
```

---

### مشکل 3: خطای اتصال به Database

```bash
# چک کردن MongoDB
sudo docker ps | grep mongodb
sudo docker logs mlm-mongodb

# ریستارت MongoDB
sudo docker restart mlm-mongodb

# چک کردن connection در Backend
cat backend/.env | grep MONGO_URL
```

---

### مشکل 4: Port در حال استفاده است

```bash
# پیدا کردن process استفاده‌کننده از port
sudo lsof -i :80
sudo lsof -i :8001
sudo lsof -i :3000

# کشتن process
sudo kill -9 <PID>
```

---

## 🔥 Firewall Configuration

اگر Firewall فعال است:

```bash
# Ubuntu/Debian (UFW)
sudo ufw allow 80
sudo ufw allow 443
sudo ufw status

# CentOS/Rocky (firewalld)
sudo firewall-cmd --permanent --add-service=http
sudo firewall-cmd --permanent --add-service=https
sudo firewall-cmd --reload
```

---

## 🔒 نصب HTTPS با Let's Encrypt

برای امن کردن سایت با SSL:

```bash
# 1. نصب Certbot
sudo apt install certbot python3-certbot-nginx  # Ubuntu/Debian
# یا
sudo yum install certbot python3-certbot-nginx  # CentOS/Rocky

# 2. دریافت Certificate
sudo certbot --nginx -d yourdomain.com

# 3. تست تمدید خودکار
sudo certbot renew --dry-run
```

---

## ⚡ بهینه‌سازی برای Production

### 1. تنظیمات Backend

ویرایش `backend/.env`:

```bash
# افزایش Rate Limit
RATE_LIMIT_CALLS=1000
RATE_LIMIT_PERIOD=60

# فعال کردن Cache
CACHE_ENABLED=true
CACHE_TTL=300

# لاگ‌گیری
LOG_LEVEL=INFO
```

### 2. تنظیمات MongoDB

```bash
# محدود کردن memory
sudo docker update --memory="1g" mlm-mongodb

# افزایش WiredTiger Cache
sudo docker exec mlm-mongodb mongosh --eval \
  "db.adminCommand({setParameter: 1, wiredTigerEngineRuntimeConfig: 'cache_size=512M'})"
```

### 3. تنظیمات Nginx

ویرایش `/etc/nginx/nginx.conf`:

```nginx
# Worker Processes
worker_processes auto;
worker_connections 1024;

# Gzip Compression
gzip on;
gzip_vary on;
gzip_min_length 1024;
gzip_types text/plain text/css text/xml text/javascript application/javascript;

# Client Body Size
client_max_body_size 50M;

# Timeouts
client_body_timeout 60s;
client_header_timeout 60s;
send_timeout 60s;
```

---

## 📊 Monitoring

### نصب PM2 Monitoring:

```bash
pm2 install pm2-logrotate
pm2 set pm2-logrotate:max_size 10M
pm2 set pm2-logrotate:retain 7

# مشاهده metrics
pm2 monit
```

### Health Checks:

```bash
# ایجاد کرون برای چک خودکار
echo "*/5 * * * * curl -f http://localhost/health || sudo systemctl restart nginx" | crontab -
```

---

## 💾 Backup و Restore

### Backup کامل:

```bash
#!/bin/bash
# backup.sh

DATE=$(date +%Y%m%d_%H%M%S)
BACKUP_DIR="./backups/$DATE"

mkdir -p $BACKUP_DIR

# MongoDB Backup
sudo docker exec mlm-mongodb mongodump --out /data/backup
sudo docker cp mlm-mongodb:/data/backup $BACKUP_DIR/mongodb

# Backend .env
cp backend/.env $BACKUP_DIR/

# فشرده‌سازی
tar -czf backup_$DATE.tar.gz $BACKUP_DIR
rm -rf $BACKUP_DIR

echo "✅ Backup completed: backup_$DATE.tar.gz"
```

### Restore:

```bash
# استخراج backup
tar -xzf backup_20250122_120000.tar.gz

# Restore MongoDB
sudo docker cp backup_20250122_120000/mongodb mlm-mongodb:/data/restore
sudo docker exec mlm-mongodb mongorestore /data/restore

# Restore .env
cp backup_20250122_120000/.env backend/.env

# ریستارت سرویس‌ها
pm2 restart all
# یا
sudo docker compose restart
```

---

## 🔄 به‌روزرسانی سیستم

```bash
# 1. Backup
./backup.sh

# 2. دانلود نسخه جدید
wget https://example.com/mlm_system_v2.zip
unzip mlm_system_v2.zip

# 3. توقف سرویس‌ها
pm2 stop all
# یا
sudo docker compose down

# 4. جایگزینی فایل‌ها
cp -r mlm_system_v2/backend/* backend/
cp -r mlm_system_v2/frontend/* frontend/

# 5. نصب وابستگی‌های جدید
cd backend && source venv/bin/activate && pip install -r requirements.txt
cd ../frontend && yarn install

# 6. Build Frontend
cd frontend && yarn build

# 7. شروع مجدد
pm2 restart all
# یا
sudo docker compose up -d --build
```

---

## 📞 پشتیبانی

### لاگ‌های مهم:

```bash
# Backend
pm2 logs mlm-backend
tail -f backend/logs/mlm_system.log

# Frontend
pm2 logs mlm-frontend

# Nginx
sudo tail -f /var/log/nginx/error.log
sudo tail -f /var/log/nginx/access.log

# MongoDB
sudo docker logs mlm-mongodb -f
```

### دستورات سریع:

```bash
# ریستارت کامل سیستم
pm2 restart all && sudo systemctl restart nginx
# یا
sudo docker compose restart && sudo systemctl restart nginx

# چک سلامت
curl http://localhost/health
curl http://localhost/api/health

# مشاهده منابع
pm2 monit
sudo docker stats
```

---

## 🎓 نکات پیشرفته

### 1. Scale کردن Backend:

```javascript
// ecosystem.config.js
{
  name: 'mlm-backend',
  instances: 2,  // 2 instance
  exec_mode: 'cluster'
}
```

### 2. Load Balancing با Nginx:

```nginx
upstream backend {
    least_conn;
    server 127.0.0.1:8001;
    server 127.0.0.1:8002;
}
```

### 3. Redis Caching:

```bash
# فعال کردن Redis در .env
REDIS_URL=redis://localhost:6379
CACHE_ENABLED=true
```

---

## ✅ Checklist نصب موفق

- [ ] MongoDB در حال اجرا است (`sudo docker ps | grep mongodb`)
- [ ] Backend در حال اجرا است (`pm2 list` یا `docker compose ps`)
- [ ] Frontend در حال اجرا است
- [ ] Nginx در حال اجرا است (`sudo systemctl status nginx`)
- [ ] Health check موفق است (`curl http://localhost/health`)
- [ ] می‌توانم وارد سیستم شوم (admin@mlm.com / admin123)
- [ ] رمز admin را تغییر داده‌ام
- [ ] Firewall پیکربندی شده (port 80/443 باز است)
- [ ] Backup اولیه گرفته شده
- [ ] Auto-start فعال است

---

## 🎉 تبریک!

سیستم MLM شما با موفقیت نصب و اجرا شد!

**🌐 دسترسی:** `http://YOUR_SERVER_IP`  
**🔐 ورود:** `admin@mlm.com` / `admin123`

---

**نکته:** این سیستم به صورت خودکار بعد از Reboot سرور راه‌اندازی می‌شود. نیازی به دستور دستی نیست!
