#!/bin/bash

# اسکریپت تست سریع تلگرام بات
# chmod +x telegram-quick-test.sh

echo "🔍 تست سیستم تلگرام MLM"
echo "================================"

# رنگ‌ها
GREEN='\033[0;32m'
RED='\033[0;31m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# 1. چک Docker Containers
echo -e "\n${YELLOW}1. چک کردن Containers...${NC}"
if docker ps | grep -q "mlm-mongodb"; then
    echo -e "${GREEN}✅ MongoDB در حال اجرا${NC}"
else
    echo -e "${RED}❌ MongoDB اجرا نیست${NC}"
    exit 1
fi

if docker ps | grep -q "mlm-backend"; then
    echo -e "${GREEN}✅ Backend در حال اجرا${NC}"
else
    echo -e "${RED}❌ Backend اجرا نیست${NC}"
    exit 1
fi

if docker ps | grep -q "mlm-telegram-bot"; then
    echo -e "${GREEN}✅ Telegram Bot در حال اجرا${NC}"
else
    echo -e "${RED}❌ Telegram Bot اجرا نیست - راه‌اندازی...${NC}"
    docker-compose up -d telegram-bot
    sleep 5
fi

# 2. چک تنظیمات در دیتابیس
echo -e "\n${YELLOW}2. چک تنظیمات تلگرام در دیتابیس...${NC}"
SETTINGS=$(docker exec mlm-mongodb mongosh mlm_production --quiet --eval "db.settings.findOne({setting_id: 'telegram'}, {_id: 0, bot_token: 0})" 2>/dev/null)

if [ -z "$SETTINGS" ] || [ "$SETTINGS" == "null" ]; then
    echo -e "${RED}❌ تنظیمات تلگرام در دیتابیس نیست${NC}"
    echo -e "${YELLOW}💡 از پنل ادمین تنظیمات را وارد کنید${NC}"
else
    echo -e "${GREEN}✅ تنظیمات موجود است${NC}"
    echo "$SETTINGS" | grep -q '"enabled": true' && echo -e "${GREEN}✅ Bot فعال است${NC}" || echo -e "${RED}❌ Bot غیرفعال است${NC}"
fi

# 3. چک لاگ‌های Bot
echo -e "\n${YELLOW}3. آخرین لاگ‌های Telegram Bot:${NC}"
docker logs --tail 20 mlm-telegram-bot 2>&1 | tail -10

# 4. تست اتصال Backend
echo -e "\n${YELLOW}4. تست اتصال به Backend API...${NC}"
HEALTH=$(curl -s http://localhost:8001/api/health 2>/dev/null)
if [ -z "$HEALTH" ]; then
    echo -e "${RED}❌ Backend در دسترس نیست${NC}"
else
    echo -e "${GREEN}✅ Backend در دسترس است${NC}"
fi

# 5. آمار collections
echo -e "\n${YELLOW}5. آمار Collections:${NC}"
CHAT_COUNT=$(docker exec mlm-mongodb mongosh mlm_production --quiet --eval "db.telegram_chats.countDocuments()" 2>/dev/null)
SESSION_COUNT=$(docker exec mlm-mongodb mongosh mlm_production --quiet --eval "db.telegram_sessions.countDocuments()" 2>/dev/null)
USER_WITH_TG=$(docker exec mlm-mongodb mongosh mlm_production --quiet --eval "db.users.countDocuments({telegram_chat_id: {\$ne: null}})" 2>/dev/null)

echo -e "   📊 telegram_chats: ${GREEN}$CHAT_COUNT${NC}"
echo -e "   📊 telegram_sessions: ${GREEN}$SESSION_COUNT${NC}"
echo -e "   📊 users با telegram: ${GREEN}$USER_WITH_TG${NC}"

# 6. دستورات مفید
echo -e "\n${YELLOW}📝 دستورات مفید:${NC}"
echo "   • مشاهده لاگ Bot:      docker logs -f mlm-telegram-bot"
echo "   • ری‌استارت Bot:       docker-compose restart telegram-bot"
echo "   • ورود به MongoDB:     docker exec -it mlm-mongodb mongosh mlm_production"
echo "   • چک تنظیمات:         docker exec mlm-mongodb mongosh mlm_production --eval 'db.settings.find({setting_id:\"telegram\"}).pretty()'"

echo -e "\n${GREEN}✅ تست تمام شد!${NC}"
echo -e "${YELLOW}💡 برای تست کامل، در تلگرام /start را به ربات بفرستید${NC}"
