#!/bin/bash

################################################################################
# MLM System - Stop Script
# متوقف کردن تمام سرویس‌ها
################################################################################

# رنگ‌ها
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'

echo -e "${BLUE}════════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}   🛑 MLM System - Stop                                    ${NC}"
echo -e "${BLUE}════════════════════════════════════════════════════════════${NC}"
echo ""

PROJECT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"

################################################################################
# متوقف کردن Backend
################################################################################
echo -e "${YELLOW}[1/3] متوقف کردن Backend...${NC}"

if [ -f "$PROJECT_DIR/backend/logs/backend.pid" ]; then
    BACKEND_PID=$(cat "$PROJECT_DIR/backend/logs/backend.pid")
    if ps -p $BACKEND_PID > /dev/null 2>&1; then
        kill $BACKEND_PID
        echo -e "${GREEN}✓ Backend متوقف شد (PID: $BACKEND_PID)${NC}"
    else
        echo -e "${YELLOW}⚠ Backend قبلاً متوقف شده${NC}"
    fi
    rm -f "$PROJECT_DIR/backend/logs/backend.pid"
else
    # اگر PID file نیست، همه process های مرتبط رو kill کن
    pkill -f "python.*server.py" && echo -e "${GREEN}✓ Backend متوقف شد${NC}" || echo -e "${YELLOW}⚠ Backend پیدا نشد${NC}"
fi

################################################################################
# متوقف کردن Frontend
################################################################################
echo -e "${YELLOW}[2/3] متوقف کردن Frontend...${NC}"

if [ -f "$PROJECT_DIR/backend/logs/frontend.pid" ]; then
    FRONTEND_PID=$(cat "$PROJECT_DIR/backend/logs/frontend.pid")
    if ps -p $FRONTEND_PID > /dev/null 2>&1; then
        kill $FRONTEND_PID
        echo -e "${GREEN}✓ Frontend متوقف شد (PID: $FRONTEND_PID)${NC}"
    else
        echo -e "${YELLOW}⚠ Frontend قبلاً متوقف شده${NC}"
    fi
    rm -f "$PROJECT_DIR/backend/logs/frontend.pid"
else
    # اگر PID file نیست، همه process های مرتبط رو kill کن
    pkill -f "craco start" && echo -e "${GREEN}✓ Frontend متوقف شد${NC}" || true
    pkill -f "react-scripts start" && echo -e "${GREEN}✓ Frontend متوقف شد${NC}" || echo -e "${YELLOW}⚠ Frontend پیدا نشد${NC}"
fi

################################################################################
# پیام نهایی
################################################################################
echo ""
echo -e "${GREEN}✓ تمام سرویس‌ها متوقف شدند${NC}"
echo ""
echo -e "${YELLOW}💡 نکته: MongoDB همچنان در حال اجرا است${NC}"
echo -e "${YELLOW}   برای متوقف کردن MongoDB:${NC}"
echo -e "${YELLOW}   docker stop mlm-mongodb${NC}"
echo ""
