"""Simple Metrics for Monitoring"""
import time
from datetime import datetime

# Global metrics
_metrics = {
    "activations_total": 0,
    "activations_success": 0,
    "activations_failed": 0,
    "rewards_distributed": 0,
    "total_queries": 0,
    "start_time": datetime.now(),
    "activation_times": []  # Last 100
}

def increment_activations(success: bool, duration: float):
    """Track activation"""
    _metrics["activations_total"] += 1
    if success:
        _metrics["activations_success"] += 1
    else:
        _metrics["activations_failed"] += 1
    
    _metrics["activation_times"].append(duration)
    if len(_metrics["activation_times"]) > 100:
        _metrics["activation_times"].pop(0)

def increment_rewards(count: int):
    """Track rewards"""
    _metrics["rewards_distributed"] += count

def get_metrics():
    """Get current metrics"""
    uptime = (datetime.now() - _metrics["start_time"]).total_seconds()
    
    avg_time = 0
    if _metrics["activation_times"]:
        avg_time = sum(_metrics["activation_times"]) / len(_metrics["activation_times"])
    
    return {
        "uptime_seconds": uptime,
        "activations": {
            "total": _metrics["activations_total"],
            "success": _metrics["activations_success"],
            "failed": _metrics["activations_failed"],
            "success_rate": _metrics["activations_success"] / _metrics["activations_total"] if _metrics["activations_total"] > 0 else 0
        },
        "performance": {
            "avg_activation_time": avg_time,
            "recent_samples": len(_metrics["activation_times"])
        },
        "rewards_distributed": _metrics["rewards_distributed"]
    }
