"""Reward Validator - اعتبارسنجی قوانین پاداش"""

from typing import Dict
import logging

logger = logging.getLogger(__name__)

_db = None

def set_database(db):
    """تنظیم database connection"""
    global _db
    _db = db


class RewardValidator:
    """اعتبارسنجی قوانین پاداش"""
    
    @staticmethod
    async def can_receive_direct_reward(user_id: str) -> bool:
        """
        بررسی اینکه کاربر می‌تواند پاداش مستقیم دریافت کند
        
        Rules:
        - نباید blocked_direct_reward = True
        - نباید is_tree_complete = True
        """
        user = await _db.users.find_one(
            {"user_id": user_id},
            {"_id": 0, "blocked_direct_reward": 1, "is_tree_complete": 1}
        )
        
        if not user:
            return False
        
        return not user.get("blocked_direct_reward") and not user.get("is_tree_complete")
    
    @staticmethod
    async def can_receive_level_reward(user_id: str) -> bool:
        """
        بررسی اینکه کاربر می‌تواند پاداش سطحی دریافت کند
        
        Rules:
        - نباید blocked_level_reward = True
        - نباید is_tree_complete = True
        """
        user = await _db.users.find_one(
            {"user_id": user_id},
            {"_id": 0, "blocked_level_reward": 1, "is_tree_complete": 1}
        )
        
        if not user:
            return False
        
        return not user.get("blocked_level_reward") and not user.get("is_tree_complete")
    
    @staticmethod
    def validate_depth_diff(depth_diff: int) -> bool:
        """
        بررسی depth_diff برای پاداش سطحی
        
        Valid depth_diffs:
        - 2: Level 3 reward
        - 4: Level 5 reward
        - 6: Level 7 reward
        """
        return depth_diff in [2, 4, 6]
    
    @staticmethod
    def is_within_level_limit(depth_diff: int) -> bool:
        """
        بررسی محدودیت 7 سطح
        """
        return depth_diff <= 7
