"""User Models - مدل‌های مربوط به کاربران"""

from pydantic import BaseModel, EmailStr, Field
from typing import Optional, List


class UserRegister(BaseModel):
    """مدل ثبت‌نام کاربر جدید"""
    email: EmailStr
    password: str = Field(min_length=6)
    phone_number: Optional[str] = None
    referral_code: Optional[str] = None
    telegram_session: Optional[str] = None


class UserLogin(BaseModel):
    """مدل ورود کاربر"""
    email: EmailStr
    password: str


class User(BaseModel):
    """مدل کامل کاربر"""
    user_id: str
    email: str
    phone_number: Optional[str] = None
    role: str = "user"  # user or admin
    status: str = "pending"  # pending, active
    referrer_id: Optional[str] = None
    
    # Materialized Path fields
    placement_path: Optional[str] = None
    placement_parent_id: Optional[str] = None
    placement_position: Optional[int] = None
    depth: Optional[int] = None
    ancestor_depths: List[dict] = []
    
    # Tree structure
    direct_children: List[str] = []
    direct_children_count: int = 0
    total_descendants: int = 0
    max_descendant_depth: int = 0  # عمیق‌ترین descendant نسبت به این کاربر
    
    # Rewards
    total_points: float = 0.0
    blocked_direct_reward: bool = False
    blocked_level_reward: bool = False
    is_tree_complete: bool = False
    
    # Timestamps
    created_at: str
    activated_at: Optional[str] = None
    
    # Other info
    referral_code: str
    telegram_chat_id: Optional[int] = None
    wallet_address: Optional[str] = None
    wallet_network: Optional[str] = None


class ChangePasswordData(BaseModel):
    """مدل تغییر رمز عبور توسط ادمین"""
    new_password: str = Field(min_length=6)


class ChangeOwnPasswordData(BaseModel):
    """مدل تغییر رمز عبور توسط خود کاربر"""
    current_password: str
    new_password: str = Field(min_length=6)


class TreeNode(BaseModel):
    """مدل نود درخت کاربران"""
    user_id: str
    email: str
    status: str
    depth: int
    total_points: float
    direct_children_count: int
    children: List['TreeNode'] = []
