"""Telegram Models - مدل‌های تلگرام (نسخه کامل)"""

from pydantic import BaseModel, Field
from typing import Optional


class TelegramSettings(BaseModel):
    """تنظیمات ربات تلگرام - نسخه کامل"""
    enabled: bool = False
    bot_token: Optional[str] = None
    bot_username: Optional[str] = None
    webapp_url: Optional[str] = None
    welcome_message: Optional[str] = "👋 سلام {user_name} عزیز! به سیستم ما خوش آمدید"
    welcome_with_ref_message: Optional[str] = "🎉 سلام {user_name} عزیز! شما با لینک دعوت {referral_code} وارد شدید"
    activation_message: Optional[str] = "✅ حساب شما فعال شد! از طریق دکمه زیر وارد داشبورد شوید"


class TelegramNotificationRequest(BaseModel):
    """درخواست ارسال نوتیفیکیشن تلگرام"""
    user_id: str = Field(description="شناسه کاربر")
    message: str = Field(min_length=1, max_length=4096, description="متن پیام")


class TelegramBroadcast(BaseModel):
    """ارسال پیام عمومی"""
    message: str = Field(min_length=1, max_length=4096, description="متن پیام")
    target: Optional[str] = Field(default="all", description="هدف ارسال: all, active, inactive")
