"""Reward Models - مدل‌های پاداش"""

from pydantic import BaseModel, Field
from typing import Optional


class RewardSettings(BaseModel):
    """تنظیمات پاداش"""
    activation_fee: float = Field(default=100.0, gt=0, description="هزینه فعال‌سازی")
    seed_initial_payment: Optional[float] = Field(default=100.0, gt=0, description="سرمایه اولیه seed")
    
    # پاداش مستقیم
    direct_first: float = Field(default=100.0, ge=0, description="پاداش زیرمجموعه اول")
    direct_second: float = Field(default=75.0, ge=0, description="پاداش زیرمجموعه دوم")
    direct_third: float = Field(default=50.0, ge=0, description="پاداش زیرمجموعه سوم")
    direct_extra: float = Field(default=25.0, ge=0, description="پاداش زیرمجموعه‌های بعدی")
    
    # پاداش سطحی
    level_3: float = Field(default=10.0, ge=0, description="پاداش سطح 3")
    level_5: float = Field(default=5.0, ge=0, description="پاداش سطح 5")
    level_7: float = Field(default=2.0, ge=0, description="پاداش سطح 7")


class Transaction(BaseModel):
    """مدل تراکنش پاداش"""
    transaction_id: str
    user_id: str
    from_user_id: str
    reward_type: str  # direct, level_3, level_5, level_7
    amount: float
    timestamp: str
    description: str
