"""
نحوه استفاده از پیام فعالسازی تلگرام در بخش auth
این کد را به routes/auth.py اضافه کنید
"""

# در ابتدای فایل auth.py این import را اضافه کنید:
# import sys
# sys.path.insert(0, '/app/backend')

# و این را هم اضافه کنید:
# from telegram_bot_simple import send_activation_message


# مثال استفاده در تابع activate (یا جایی که کاربر فعال می‌شود):

async def activate_user_example(user_id: str):
    """
    مثال: وقتی کاربر حساب خود را فعال می‌کند
    """
    db = await get_db()
    
    # پیدا کردن کاربر
    user = await db.users.find_one({"user_id": user_id})
    
    if not user:
        return {"error": "کاربر پیدا نشد"}
    
    # فعالسازی کاربر
    await db.users.update_one(
        {"user_id": user_id},
        {"$set": {"is_active": True}}
    )
    
    # ارسال پیام فعالسازی تلگرام (اگر chat_id دارد)
    if user.get("telegram_chat_id"):
        try:
            from telegram_bot_simple import send_activation_message
            
            await send_activation_message(
                telegram_chat_id=user["telegram_chat_id"],
                user_email=user["email"],
                referral_code=user["referral_code"]
            )
            logger.info(f"✅ پیام فعالسازی تلگرام به {user['email']} ارسال شد")
        except Exception as e:
            logger.error(f"❌ خطا در ارسال پیام فعالسازی: {e}")
    
    return {"message": "کاربر فعال شد"}


# مثال استفاده در register (ذخیره telegram session):

async def register_with_telegram_example(register_data: dict):
    """
    مثال: ثبت‌نام با اطلاعات تلگرام
    """
    db = await get_db()
    
    # دریافت tg_session از query params
    tg_session = register_data.get("tg_session")
    
    # ایجاد کاربر جدید
    new_user = {
        "user_id": str(uuid.uuid4()),
        "email": register_data["email"],
        "referral_code": generate_referral_code(),
        "is_active": False,
        "telegram_chat_id": None,  # فعلاً خالی
        "created_at": datetime.now(timezone.utc).isoformat()
    }
    
    await db.users.insert_one(new_user)
    
    # اگر از تلگرام آمده، chat_id را پیدا کنید
    if tg_session:
        try:
            session = await db.telegram_sessions.find_one({"session_id": tg_session})
            
            if session and not session.get("used"):
                # ذخیره chat_id در user
                await db.users.update_one(
                    {"user_id": new_user["user_id"]},
                    {"$set": {"telegram_chat_id": session["chat_id"]}}
                )
                
                # علامت‌گذاری session به عنوان استفاده شده
                await db.telegram_sessions.update_one(
                    {"session_id": tg_session},
                    {"$set": {"used": True, "user_id": new_user["user_id"]}}
                )
                
                logger.info(f"✅ chat_id {session['chat_id']} به کاربر {new_user['email']} لینک شد")
        except Exception as e:
            logger.error(f"❌ خطا در لینک کردن telegram session: {e}")
    
    return new_user


# مثال استفاده برای ارسال نوتیفیکیشن پاداش:

async def send_reward_notification_example(user_id: str, reward_amount: float):
    """
    مثال: ارسال نوتیفیکیشن پاداش
    """
    db = await get_db()
    
    user = await db.users.find_one({"user_id": user_id})
    
    if user and user.get("telegram_chat_id"):
        try:
            from telegram_bot_simple import send_notification
            
            message = f"""🎉 پاداش جدید!

💰 مبلغ: ${reward_amount:.2f}
👤 کاربر: {user['email']}

✅ پاداش به حساب شما اضافه شد!"""
            
            await send_notification(
                telegram_chat_id=user["telegram_chat_id"],
                message=message
            )
            
            logger.info(f"✅ نوتیفیکیشن پاداش به {user['email']} ارسال شد")
        except Exception as e:
            logger.error(f"❌ خطا در ارسال نوتیفیکیشن: {e}")
