#!/bin/bash
# MLM Quick Fix - رفع مشکل IPv4 و دسترسی خارجی

SERVER_IP=$(curl -4 -s ifconfig.me 2>/dev/null || echo "51.254.132.234")

echo "🔧 در حال رفع مشکلات..."

# 1. Fix Backend .env
cd ~/mlm_final_production/backend 2>/dev/null || cd mlm_final_production/backend
cat > .env << EOF
MONGO_URL=mongodb://127.0.0.1:27017
DB_NAME=mlm_production
JWT_SECRET=$(openssl rand -hex 32)
CORS_ORIGINS=*
HOST=0.0.0.0
PORT=8001
EOF

# 2. Fix Frontend .env
cd ../frontend
cat > .env << EOF
REACT_APP_BACKEND_URL=http://$SERVER_IP:8001
REACT_APP_API_URL=http://$SERVER_IP:8001/api
EOF

# 3. Rebuild Frontend
export REACT_APP_BACKEND_URL=http://$SERVER_IP:8001
yarn build > /dev/null 2>&1

cd ..

# 4. توقف سرویس‌های قبلی
pkill -f "uvicorn" 2>/dev/null || true
pkill -f "serve" 2>/dev/null || true
sleep 2

# 5. MongoDB
sudo docker start mlm-mongodb 2>/dev/null || \
sudo docker run -d --name mlm-mongodb --restart unless-stopped \
    -p 0.0.0.0:27017:27017 \
    -v mlm-mongodb-data:/data/db \
    mongo:7.0

sleep 5

# 6. Firewall
sudo ufw allow 8001/tcp 2>/dev/null || true
sudo ufw allow 3000/tcp 2>/dev/null || true

# 7. راه‌اندازی Backend
cd backend
source venv/bin/activate
nohup uvicorn server:app --host 0.0.0.0 --port 8001 > backend.log 2>&1 &
sleep 5

# 8. راه‌اندازی Frontend
cd ../frontend
nohup npx serve -s build -l 3000 --single --no-clipboard > frontend.log 2>&1 &
sleep 3

echo ""
echo "✅ سیستم راه‌اندازی شد!"
echo ""
echo "🌐 دسترسی: http://$SERVER_IP:3000"
echo "🔐 ورود: admin@mlm.com / admin123"
echo ""
