#!/bin/bash

################################################################################
# Quick Docker Compose Deploy
# نصب سریع با Docker Compose
################################################################################

set -e

RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'

echo -e "${BLUE}════════════════════════════════════════════${NC}"
echo -e "${BLUE}   🚀 MLM System - Docker Quick Deploy   ${NC}"
echo -e "${BLUE}════════════════════════════════════════════${NC}"
echo ""

# چک Docker
if ! command -v docker &> /dev/null; then
    echo -e "${YELLOW}⚠️  Docker نصب نیست. در حال نصب...${NC}"
    curl -fsSL https://get.docker.com | sh
    sudo systemctl start docker
    sudo systemctl enable docker
    echo -e "${GREEN}✔ Docker نصب شد${NC}"
else
    echo -e "${GREEN}✔ Docker موجود است${NC}"
fi

echo ""

# توقف containers قدیمی
echo -e "${YELLOW}🧹 پاکسازی containers قدیمی...${NC}"
sudo docker compose down 2>/dev/null || true
echo ""

# Build و Start
echo -e "${YELLOW}🔧 Build و Start کردن سرویس‌ها...${NC}"
echo -e "${YELLOW}⏰ زمان تقریبی: 3-5 دقیقه${NC}"
echo ""

sudo docker compose up -d --build

echo ""
echo -e "${YELLOW}⏳ در انتظار راه‌اندازی سرویس‌ها...${NC}"
sleep 10

echo ""
echo -e "${GREEN}════════════════════════════════════════════${NC}"
echo -e "${GREEN}          ✅ نصب کامل شد!          ${NC}"
echo -e "${GREEN}════════════════════════════════════════════${NC}"
echo ""

# نمایش وضعیت
echo -e "${YELLOW}📊 وضعیت سرویس‌ها:${NC}"
sudo docker compose ps

echo ""
echo -e "${BLUE}🌐 دسترسی:${NC}"
SERVER_IP=$(curl -s ifconfig.me 2>/dev/null || hostname -I | awk '{print $1}')
echo -e "   🌍 آدرس اصلی:  http://$SERVER_IP"
echo -e "   📱 Local:       http://localhost"
echo ""

echo -e "${BLUE}🔐 ورود:${NC}"
echo -e "   Email:    admin@mlm.com"
echo -e "   Password: admin123"
echo ""

echo -e "${BLUE}✨ ویژگی‌های سیستم:${NC}"
echo -e "   ✅ Dashboard Seed در admin panel"
echo -e "   ✅ گزارشات جامع (4 تب: Financial, Rewards, Users, System)"
echo -e "   ✅ Redis cache فعال"
echo -e "   ✅ Auto-restart بعد از reboot"
echo ""

echo -e "${YELLOW}🔧 دستورات مفید:${NC}"
echo -e "   sudo docker compose logs -f backend   # لاگ Backend"
echo -e "   sudo docker compose logs -f frontend  # لاگ Frontend"
echo -e "   sudo docker compose restart backend   # ریستارت Backend"
echo -e "   sudo docker compose down              # توقف"
echo -e "   sudo docker compose up -d             # شروع"
echo ""

echo -e "${GREEN}✨ سیستم آماده استفاده است! ✨${NC}"
echo ""
