"""Message Models - مدل‌های پیام"""

from pydantic import BaseModel, Field
from typing import Optional, List


class MessageCreate(BaseModel):
    """ایجاد پیام جدید"""
    recipient_id: str = Field(description="شناسه گیرنده")
    subject: str = Field(min_length=1, max_length=200)
    content: str = Field(min_length=1, max_length=10000)


class MessageReply(BaseModel):
    """پاسخ به پیام"""
    content: str = Field(min_length=1, max_length=10000)


class Message(BaseModel):
    """مدل کامل پیام"""
    message_id: str
    sender_id: str
    sender_email: str
    recipient_id: str
    recipient_email: str
    subject: str
    content: str
    is_read: bool = False
    parent_id: Optional[str] = None  # برای پاسخ‌ها
    created_at: str
    read_at: Optional[str] = None
