# 📦 MLM System - بسته نصب خودکار کامل

## ✅ آماده شده توسط: AI DevOps Assistant

---

## 🎯 خلاصه تغییرات

این بسته یک **سیستم نصب کاملاً خودکار** برای پروژه MLM شما است که تمامی مشکلات deployment دستی را حل می‌کند:

### ❌ مشکلات قبلی:
- Backend با nohup اجرا می‌شد → بعد از reboot خاموش می‌شد
- Frontend در حالت development اجرا می‌شد
- هیچ service manager وجود نداشت
- Nginx configuration دستی بود
- Database indexes اعمال نمی‌شد

### ✅ راه‌حل‌های اعمال شده:
1. **نصب خودکار کامل** - یک دستور و تمام!
2. **PM2 Process Manager** - مدیریت حرفه‌ای سرویس‌ها
3. **Docker Compose** - راه‌حل ایزوله و قابل اطمینان
4. **Nginx Auto-Config** - پیکربندی خودکار reverse proxy
5. **Auto-start** - راه‌اندازی خودکار بعد از reboot
6. **Production Build** - Frontend با بهینه‌سازی کامل
7. **Database Indexes** - اعمال خودکار تمام indexes

---

## 📂 محتویات بسته

```
mlm_production_ready.zip
├── auto-install.sh           ⭐ نصب خودکار با PM2
├── docker-deploy.sh          ⭐ نصب خودکار با Docker
├── docker-compose.yml        🐳 Docker configuration
├── ecosystem.config.js       ⚡ PM2 configuration
├── nginx.conf                🌐 Nginx configuration
├── start-system.sh           ▶️ شروع سیستم
├── stop-system.sh            ⏹️ توقف سیستم
├── INSTALL.txt               📄 راهنمای سریع
├── README_FA.md              📖 راهنمای کامل فارسی
├── README_DEPLOY.md          📖 راهنمای deployment انگلیسی
├── backend/
│   ├── Dockerfile            🐳 Docker image backend
│   ├── server.py             ✅ بدون تغییر
│   ├── requirements.txt      ✅ بدون تغییر
│   └── ...
└── frontend/
    ├── Dockerfile            🐳 Docker image frontend  
    ├── nginx-frontend.conf   🌐 Nginx برای container
    ├── package.json          ✅ بدون تغییر
    └── ...
```

---

## 🚀 نصب فوری (2 روش)

### روش 1: Docker (توصیه می‌شود) ⭐

```bash
unzip mlm_production_ready.zip
cd mlm_production_ready
chmod +x docker-deploy.sh
sudo ./docker-deploy.sh
```

**زمان نصب:** 3-5 دقیقه  
**مزایا:** ایزوله، قابل اطمینان، سریع

---

### روش 2: Native با PM2

```bash
unzip mlm_production_ready.zip
cd mlm_production_ready
chmod +x auto-install.sh
sudo ./auto-install.sh
```

**زمان نصب:** 5-10 دقیقه  
**مزایا:** کنترل بیشتر، منابع کمتر

---

## 🔐 اطلاعات ورود

```
Email:    admin@mlm.com
Password: admin123
```

⚠️ **حتماً بعد از اولین ورود رمز را تغییر دهید!**

---

## 🌐 دسترسی

```
Main:   http://YOUR_SERVER_IP
Local:  http://localhost
Health: http://YOUR_SERVER_IP/health
API:    http://YOUR_SERVER_IP/api
```

---

## 🛠️ مدیریت

### Docker Compose:
```bash
sudo docker compose ps              # وضعیت
sudo docker compose logs -f backend # لاگ
sudo docker compose restart         # ریستارت
sudo docker compose down            # توقف
sudo docker compose up -d           # شروع
```

### PM2:
```bash
pm2 list                # وضعیت
pm2 logs mlm-backend    # لاگ
pm2 restart all         # ریستارت
pm2 stop all            # توقف
pm2 start all           # شروع
```

---

## 📋 چک‌لیست قبل از تحویل

✅ همه فایل‌های deployment ایجاد شده‌اند  
✅ Docker Compose configuration کامل است  
✅ PM2 Ecosystem configuration کامل است  
✅ Nginx configuration آماده است  
✅ Dockerfiles برای backend و frontend ایجاد شده‌اند  
✅ راهنمای کامل فارسی و انگلیسی نوشته شده  
✅ اسکریپت‌های start/stop ایجاد شده‌اند  
✅ تمام فایل‌های executable هستند  
✅ Database indexes در اسکریپت نصب اعمال می‌شوند  

---

## 🎯 ویژگی‌های کلیدی

1. **Zero Manual Steps**
   - هیچ دستور SSH دستی نیاز نیست
   - همه چیز خودکار است

2. **Auto-start after Reboot**
   - MongoDB: Docker restart policy
   - Redis: Docker restart policy
   - Backend: PM2 startup script
   - Frontend: PM2 startup script
   - Nginx: systemd enabled

3. **Production Ready**
   - Frontend با yarn build
   - Database indexes اعمال شده
   - Nginx reverse proxy
   - PM2 process management
   - Docker isolation

4. **Easy Management**
   - Start: `./start-system.sh`
   - Stop: `./stop-system.sh`
   - Logs: `pm2 logs` یا `docker compose logs`
   - Status: `pm2 list` یا `docker compose ps`

5. **Comprehensive Documentation**
   - INSTALL.txt - راهنمای سریع
   - README_FA.md - راهنمای کامل فارسی
   - README_DEPLOY.md - راهنمای deployment
   - Inline comments در تمام اسکریپت‌ها

---

## 🔄 فرآیند نصب خودکار

### 1. auto-install.sh:
```
1. نصب Docker
2. نصب Node.js & Yarn
3. نصب PM2
4. راه‌اندازی MongoDB (Docker)
5. راه‌اندازی Redis (Docker)
6. نصب Backend dependencies
7. نصب Frontend dependencies
8. Build Frontend برای production
9. ایجاد .env files
10. پیکربندی Nginx
11. راه‌اندازی با PM2
12. اعمال Database indexes
13. فعال‌سازی PM2 startup
```

### 2. docker-deploy.sh:
```
1. نصب Docker (اگر نیست)
2. Build تمام images
3. راه‌اندازی با docker compose
4. تمام!
```

---

## 🐛 عیب‌یابی

### مشکل: Backend راه‌اندازی نمی‌شود
```bash
pm2 logs mlm-backend --lines 50
sudo docker exec mlm-mongodb mongosh --eval "db.version()"
```

### مشکل: Frontend نمایش داده نمی‌شود
```bash
sudo nginx -t
pm2 logs mlm-frontend
```

### مشکل: Port در حال استفاده
```bash
sudo lsof -i :80
sudo lsof -i :8001
sudo kill -9 <PID>
```

---

## 📊 معماری سیستم

```
Internet
   ↓
[Nginx :80] (Reverse Proxy)
   │
   ├───> [Frontend :3000] (React Production Build / PM2 or Docker)
   │
   └───> [Backend :8001] (FastAPI / PM2 or Docker)
           │
           ├──> [MongoDB :27017] (Docker)
           │
           └──> [Redis :6379] (Docker)
```

---

## 💾 فایل‌های کلیدی ایجاد شده

1. **auto-install.sh** (29KB)
   - نصب خودکار کامل با PM2
   - نصب تمام dependencies
   - پیکربندی Nginx
   - راه‌اندازی سرویس‌ها

2. **docker-compose.yml**
   - کانفیگ کامل Docker
   - MongoDB + Redis + Backend + Frontend + Nginx
   - Health checks
   - Restart policies

3. **ecosystem.config.js**
   - کانفیگ PM2
   - Backend و Frontend
   - Log management
   - Auto-restart

4. **nginx.conf**
   - Reverse proxy configuration
   - Frontend و Backend routing
   - Timeouts و Headers

5. **Dockerfiles**
   - Backend: Python 3.11 + Dependencies
   - Frontend: Multi-stage build + Nginx

---

## 🎓 نکات مهم برای استفاده

1. **راه‌اندازی اولیه:**
   - فقط یکی از دو روش (Docker یا PM2) را انتخاب کنید
   - بعد از نصب، سیستم خودکار start می‌شود
   - Firewall را برای port 80/443 باز کنید

2. **مدیریت روزانه:**
   - برای چک کردن: `pm2 list` یا `docker compose ps`
   - برای لاگ: `pm2 logs` یا `docker compose logs -f`
   - برای ریستارت: `pm2 restart all` یا `docker compose restart`

3. **بعد از Reboot:**
   - همه چیز خودکار start می‌شود
   - نیازی به دستور دستی نیست
   - فقط چک کنید: `curl http://localhost/health`

4. **Backup:**
   - MongoDB: `docker exec mlm-mongodb mongodump`
   - .env files: کپی از `backend/.env`
   - Frontend build: `frontend/build/`

5. **به‌روزرسانی:**
   - توقف سرویس‌ها
   - جایگزینی کدهای جدید
   - نصب dependencies جدید
   - Build مجدد frontend
   - شروع مجدد

---

## ✨ مزایای این راه‌حل

| قبل | بعد |
|-----|-----|
| نصب دستی | یک دستور خودکار |
| nohup برای backend | PM2 با auto-restart |
| dev mode برای frontend | Production build |
| بدون nginx | Nginx خودکار |
| دستی راه‌اندازی بعد از reboot | Auto-start کامل |
| بدون service management | PM2 + systemd |
| Manual indexes | خودکار اعمال |

---

## 📞 پشتیبانی

همه مستندات لازم در بسته موجود است:
- `INSTALL.txt` - شروع سریع
- `README_FA.md` - راهنمای کامل فارسی
- `README_DEPLOY.md` - راهنمای deployment
- `docs/` - مستندات فنی

---

## 🎉 نتیجه

این بسته یک **راه‌حل production-ready کامل** برای deployment سیستم MLM است که:

✅ **صفر دستور دستی** نیاز دارد  
✅ **خودکار راه‌اندازی** می‌شود  
✅ **بعد از reboot** کار می‌کند  
✅ **مستندات کامل** دارد  
✅ **دو روش deployment** ارائه می‌دهد  

**فقط یک دستور و تمام:**
```bash
sudo ./docker-deploy.sh
```

یا

```bash
sudo ./auto-install.sh
```

---

**تاریخ ایجاد:** 2025-01-22  
**نسخه:** 4.0 Production Ready  
**سازگار با:** Ubuntu 18+, Debian 10+, CentOS 7+, Rocky Linux
