# 🚀 MLM System - نصب خودکار کامل

## 🎯 مشخصات

این نسخه یک سیستم MLM کاملاً اتوماتیک با قابلیت **Zero Manual Steps** است:

✅ **نصب با یک دستور**
✅ **Auto-start بعد از reboot**
✅ **Nginx Reverse Proxy خودکار**
✅ **PM2 Process Management**
✅ **Docker برای MongoDB و Redis**
✅ **Production-Ready Build**
✅ **Database Indexes اتوماتیک**

---

## 💻 نیازمندی‌ها

- **سیستم‌عامل:** Ubuntu 18+, Debian 10+, CentOS 7+, Rocky Linux
- **RAM:** حداقل 2GB
- **فضای دیسک:** حداقل 5GB
- **دسترسی Root** یا sudo

**همه چیز دیگر خودکار نصب می‌شود!**

---

## 🛠️ روش نصب

### 🐳 روش 1: Docker Compose (توصیه می‌شود)

این روش **سریع‌تر، ساده‌تر و قابل اعتمادتر** است.

```bash
# 1. استخراج فایل زیپ
unzip mlm_system.zip
cd mlm_system

# 2. نصب Docker (اگر نصب نیست)
curl -fsSL https://get.docker.com | sh
sudo systemctl start docker
sudo systemctl enable docker

# 3. راه‌اندازی سیستم
sudo docker compose up -d

# 4. چک کردن وضعیت
sudo docker compose ps
```

**تمام! سیستم آماده است.**

🌐 دسترسی: `http://YOUR_SERVER_IP`

---

### ⚡ روش 2: نصب PM2 (بدون Docker)

اگر نمی‌خواهید از Docker استفاده کنید:

```bash
# 1. استخراج فایل
unzip mlm_system.zip
cd mlm_system

# 2. اجرای اسکریپت نصب خودکار
chmod +x auto-install.sh
sudo ./auto-install.sh
```

**این اسکریپت به طور خودکار نصب می‌کند:**
- Docker
- MongoDB
- Redis
- Node.js & Yarn
- PM2
- Nginx
- Python Dependencies
- Frontend Build

**زمان نصب:** 5-10 دقیقه

---

## 🔐 اطلاعات ورود پیش‌فرض

```
Email:    admin@mlm.com
Password: admin123
```

⚠️ **حتماً بعد از اولین ورود رمز را تغییر دهید!**

---

## 🛠️ مدیریت سیستم

### Docker Compose

```bash
# مشاهده وضعیت
sudo docker compose ps

# مشاهده logs
sudo docker compose logs -f backend
sudo docker compose logs -f frontend

# ریستارت سرویس‌ها
sudo docker compose restart backend
sudo docker compose restart frontend

# توقف سیستم
sudo docker compose down

# شروع سیستم
sudo docker compose up -d
```

### PM2

```bash
# مشاهده وضعیت
pm2 list

# مشاهده logs
pm2 logs mlm-backend
pm2 logs mlm-frontend

# ریستارت
pm2 restart mlm-backend
pm2 restart mlm-frontend

# توقف
pm2 stop all

# شروع
pm2 start all
```

### Nginx

```bash
# بررسی وضعیت
sudo systemctl status nginx

# ریستارت
sudo systemctl restart nginx

# تست configuration
sudo nginx -t
```

---

## 💡 نکات مهم

### 1. Firewall

اگر firewall فعال است، پورت‌ها را باز کنید:

```bash
sudo ufw allow 80
sudo ufw allow 443  # برای HTTPS
```

### 2. HTTPS (SSL)

برای فعال‌سازی HTTPS با Let's Encrypt:

```bash
# نصب Certbot
sudo apt install certbot python3-certbot-nginx  # Ubuntu/Debian
# یا
sudo yum install certbot python3-certbot-nginx  # CentOS/Rocky

# دریافت SSL Certificate
sudo certbot --nginx -d yourdomain.com
```

### 3. بهینه‌سازی برای Production

#### Backend (.env)
```bash
RATE_LIMIT_CALLS=100
RATE_LIMIT_PERIOD=60
CACHE_ENABLED=true
```

#### MongoDB
```bash
# تنظیم memory limit برای container
sudo docker update --memory="1g" mlm-mongodb
```

---

## 🐞 عیب‌یابی

### چک Health

```bash
curl http://localhost/health
```

انتظار:
```json
{
  "status": "ok",
  "mongodb": true,
  "seed_user": true
}
```

### مشکلات متداول

**1. Backend راه‌اندازی نمی‌شود**

```bash
# چک logs
pm2 logs mlm-backend --lines 50
# یا
sudo docker compose logs backend

# چک MongoDB
sudo docker exec mlm-mongodb mongosh --eval "db.version()"
```

**2. Frontend نمایش داده نمی‌شود**

```bash
# چک Nginx
sudo nginx -t
sudo systemctl status nginx

# چک Frontend service
pm2 logs mlm-frontend
```

**3. Database Connection Error**

```bash
# چک MongoDB
sudo docker ps | grep mongodb
sudo docker logs mlm-mongodb

# ریستارت MongoDB
sudo docker restart mlm-mongodb
```

---

## 📊 معماری سیستم

```
[کاربر] 
   ↓
[Nginx :80] (Reverse Proxy)
   │
   ├───> [Frontend :3000] (React SPA)
   │
   └───> [Backend :8001] (FastAPI)
            │
            ├──> [MongoDB :27017]
            │
            └──> [Redis :6379]
```

---

## 📝 فایل‌های مهم

```
mlm_system/
├── auto-install.sh          # نصب خودکار PM2
├── docker-compose.yml       # Docker Compose setup
├── ecosystem.config.js      # PM2 configuration
├── nginx.conf               # Nginx config
├── backend/
│   ├── Dockerfile
│   ├── server.py
│   ├── requirements.txt
│   └── .env
└── frontend/
    ├── Dockerfile
    ├── package.json
    └── .env
```

---

## ✨ ویژگی‌های اصلی

- ✅ **Materialized Path** برای MLM tree
- ✅ **Zero Traversal** - بدون BFS/DFS
- ✅ **88% کاهش queries**
- ✅ **90% کاهش response time**
- ✅ **Atomic Operations** - Race condition safe
- ✅ **Real-time Rewards**
- ✅ **Production Indexes**
- ✅ **Crypto Integration** (TRON/BSC)
- ✅ **Telegram Bot Support**
- ✅ **Admin Panel**

---

## 🔄 Backup و Restore

### Backup

```bash
# MongoDB Backup
sudo docker exec mlm-mongodb mongodump --out /data/backup
sudo docker cp mlm-mongodb:/data/backup ./mongodb_backup_$(date +%Y%m%d)

# فشرده‌سازی
tar -czf mlm_backup_$(date +%Y%m%d).tar.gz mongodb_backup_*
```

### Restore

```bash
# استخراج backup
tar -xzf mlm_backup_20250101.tar.gz

# Restore به MongoDB
sudo docker cp mongodb_backup_20250101 mlm-mongodb:/data/restore
sudo docker exec mlm-mongodb mongorestore /data/restore
```

---

## 📞 پشتیبانی

برای مشکلات فنی:
- چک کردن logs: `pm2 logs` یا `docker compose logs`
- Health Check: `curl http://localhost/health`
- مستندات: `./docs/`

---

## 🎓 مجوزها

برای نصب HTTPS:
```bash
sudo certbot --nginx -d yourdomain.com
```

برای monitoring:
```bash
pm2 install pm2-logrotate
pm2 monit
```

---

**🎉 تمام! سیستم شما آماده استفاده است.**

🌐 دسترسی: `http://YOUR_SERVER_IP`
