module.exports = {
  apps: [
    {
      name: 'mlm-backend',
      script: 'venv/bin/python',
      args: 'server.py',
      cwd: './backend',
      interpreter: 'none',
      instances: 1,
      autorestart: true,
      watch: false,
      max_memory_restart: '1G',
      env: {
        NODE_ENV: 'production'
      },
      error_file: './backend/logs/pm2-error.log',
      out_file: './backend/logs/pm2-out.log',
      log_file: './backend/logs/pm2-combined.log',
      time: true
    },
    {
      name: 'mlm-frontend',
      script: 'npx',
      args: 'serve -s build -l 3000 --single',
      cwd: './frontend',
      instances: 1,
      autorestart: true,
      watch: false,
      max_memory_restart: '500M',
      env: {
        NODE_ENV: 'production'
      },
      error_file: './backend/logs/frontend-error.log',
      out_file: './backend/logs/frontend-out.log',
      log_file: './backend/logs/frontend-combined.log',
      time: true
    }
  ]
};
