"""Routes Package - تمام API Endpoints"""

from fastapi import APIRouter

# ایجاد router اصلی
api_router = APIRouter(prefix="/api")

# Import all routes
from . import auth
from . import user
from . import admin
from . import crypto
from . import tickets
from . import messages
from . import announcements
from . import telegram
from . import setup
from . import reports  # 🆕 این خط

# Include all routers
api_router.include_router(auth.router, tags=["Auth"])
api_router.include_router(user.router, tags=["User"])
api_router.include_router(admin.router, tags=["Admin"])
api_router.include_router(crypto.router, tags=["Crypto"])
api_router.include_router(tickets.router, tags=["Tickets"])
api_router.include_router(messages.router, tags=["Messages"])
api_router.include_router(announcements.router, tags=["Announcements"])
api_router.include_router(telegram.router, tags=["Telegram"])
api_router.include_router(setup.router, tags=["Setup"])
api_router.include_router(reports.router, tags=["Reports"])  # 🆕 این خط

__all__ = ['api_router']