"""
Configuration Management
تنظیمات سیستم و environment variables
"""
import os
from dotenv import load_dotenv
from pathlib import Path

# Load environment variables
ROOT_DIR = Path(__file__).parent
load_dotenv(ROOT_DIR / '.env')

# ==================== DATABASE CONFIG ====================
MONGO_URL = os.environ.get('MONGO_URL', 'mongodb://localhost:27017')
DB_NAME = os.environ.get('DB_NAME', 'mlm_database')

# ==================== JWT CONFIG ====================
JWT_SECRET = os.environ.get('JWT_SECRET', 'mlm-secret-key-CHANGE-IN-PRODUCTION-' + os.urandom(32).hex())
JWT_ALGORITHM = "HS256"
JWT_EXPIRATION_HOURS = 720  # 30 days

# ==================== SECURITY CONFIG ====================
# Rate limiting
RATE_LIMIT_ENABLED = os.environ.get('RATE_LIMIT_ENABLED', 'true').lower() == 'true'
RATE_LIMIT_CALLS = int(os.environ.get('RATE_LIMIT_CALLS', '100'))
RATE_LIMIT_PERIOD = int(os.environ.get('RATE_LIMIT_PERIOD', '60'))  # seconds

# CORS
CORS_ORIGINS = os.environ.get('CORS_ORIGINS', '*').split(',')

# ==================== PERFORMANCE CONFIG ====================
# Caching
CACHE_ENABLED = os.environ.get('CACHE_ENABLED', 'false').lower() == 'true'
CACHE_TTL = int(os.environ.get('CACHE_TTL', '300'))  # 5 minutes

# BFS Batch Size
BFS_BATCH_SIZE = int(os.environ.get('BFS_BATCH_SIZE', '50'))

# ==================== LOGGING CONFIG ====================
LOG_LEVEL = os.environ.get('LOG_LEVEL', 'INFO')
LOG_FILE = os.environ.get('LOG_FILE', 'logs/mlm_system.log')

# ==================== FEATURE FLAGS ====================
ENABLE_EMAIL_NOTIFICATIONS = os.environ.get('ENABLE_EMAIL_NOTIFICATIONS', 'false').lower() == 'true'
ENABLE_AUDIT_LOGS = os.environ.get('ENABLE_AUDIT_LOGS', 'true').lower() == 'true'

# ==================== MLM SYSTEM CONFIG ====================
# Tree Structure
MAX_DIRECT_CHILDREN = 3
MAX_REWARD_DEPTH = 7  # محدودیت دریافت جایزه تا 7 سطح

# Default Rewards (fallback if not in DB)
DEFAULT_ACTIVATION_FEE = 100.0
DEFAULT_SEED_INITIAL = 100.0
DEFAULT_DIRECT_FIRST = 50.0
DEFAULT_DIRECT_SECOND = 30.0
DEFAULT_DIRECT_THIRD = 20.0
DEFAULT_DIRECT_EXTRA = 10.0
DEFAULT_LEVEL_3 = 15.0
DEFAULT_LEVEL_5 = 10.0
DEFAULT_LEVEL_7 = 5.0
DEFAULT_MIN_WITHDRAWAL = 50.0
