# 🚀 MLM System with Materialized Path

## 📋 خلاصه تغییرات

این نسخه یک **بازنویسی کامل** سیستم MLM با استفاده از **Materialized Path** است که:

✅ **حذف کامل traversal** (BFS/DFS/recursion/graphLookup)
✅ **کاهش 88% queries** (از 80-120 به 16-20 query)
✅ **کاهش 90% زمان پاسخ** (از 2-10s به 200-500ms)
✅ **Real-time reward calculation** بدون پیمایش
✅ **آماده برای 100,000+ کاربر**
✅ **معماری ماژولار و واضح**

---

## 🎯 تفاوت‌های کلیدی

| ویژگی | سیستم قبلی | سیستم جدید |
|-------|-----------|------------|
| **Placement** | BFS با 10-100 query | 1-2 query با index |
| **Reward Calc** | While loop + 7-10 query | 0 query - از ancestor_depths |
| **Tree Stats** | $graphLookup | Simple field: total_descendants |
| **Queries per Activation** | 80-120 | 16-20 |
| **Response Time** | 2-10s | 200-500ms |
| **Scalability** | Max 10K users | 100K+ users |

---

## 📦 نصب و راه‌اندازی

### پیش‌نیازها

- Python 3.8+
- MongoDB 4.4+
- Node.js 16+
- Yarn

### نصب سریع

```bash
# 1. استخراج فایل
unzip mlm_materialized_path.zip
cd mlm_materialized_path

# 2. اجرای script نصب
chmod +x install.sh
./install.sh

# 3. تنظیم environment variables
cp backend/.env.example backend/.env
cp frontend/.env.example frontend/.env

# ویرایش کنید:
nano backend/.env
nano frontend/.env

# 4. اجرای سرویس‌ها
cd backend && python server.py &
cd frontend && yarn start
```

---

## 📖 مستندات

- **طراحی کامل:** `MATERIALIZED_PATH_DESIGN.md`
- **راهنمای توسعه‌دهنده:** `DEVELOPER_GUIDE.md`

---

## 🧪 تست سیستم

```bash
# Health check
curl http://localhost:8001/api/health

# ثبت‌نام
curl -X POST http://localhost:8001/api/auth/register \
  -H "Content-Type: application/json" \
  -d '{"email":"test@test.com","password":"123456"}'
```

---

**نسخه:** 2.0.0 (Materialized Path)
**تاریخ:** 2025-12-17
