#!/bin/bash

################################################################################
# MLM System - Quick Start Script
# این اسکریپت تمام سرویس‌ها رو به صورت خودکار راه‌اندازی می‌کنه
################################################################################

set -e

# رنگ‌ها
RED='\033[0;31m'
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
BLUE='\033[0;34m'
NC='\033[0m'

echo -e "${BLUE}════════════════════════════════════════════════════════════${NC}"
echo -e "${BLUE}   🚀 MLM System - Quick Start                             ${NC}"
echo -e "${BLUE}════════════════════════════════════════════════════════════${NC}"
echo ""

# پوشه اصلی
PROJECT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
cd "$PROJECT_DIR"

################################################################################
# 1. چک کردن MongoDB
################################################################################
echo -e "${YELLOW}[1/5] چک کردن MongoDB...${NC}"

if docker ps | grep -q mlm-mongodb; then
    echo -e "${GREEN}✓ MongoDB در حال اجرا است${NC}"
elif docker ps -a | grep -q mlm-mongodb; then
    echo -e "${YELLOW}→ شروع MongoDB...${NC}"
    docker start mlm-mongodb
    sleep 2
    echo -e "${GREEN}✓ MongoDB شروع شد${NC}"
else
    echo -e "${YELLOW}→ ایجاد و اجرای MongoDB...${NC}"
    docker run -d \
        --name mlm-mongodb \
        -p 27017:27017 \
        -v mongodb_data:/data/db \
        mongo:latest
    sleep 3
    echo -e "${GREEN}✓ MongoDB ایجاد و اجرا شد${NC}"
fi

################################################################################
# 2. راه‌اندازی Backend
################################################################################
echo ""
echo -e "${YELLOW}[2/5] راه‌اندازی Backend...${NC}"

cd "$PROJECT_DIR/backend"

# چک کردن venv
if [ ! -d "venv" ]; then
    echo -e "${YELLOW}→ ایجاد virtual environment...${NC}"
    python3 -m venv venv
fi

# فعال کردن venv
source venv/bin/activate

# نصب وابستگی‌ها
echo -e "${YELLOW}→ نصب وابستگی‌های Python...${NC}"
pip install -r requirements.txt --quiet

# ایجاد پوشه logs
mkdir -p logs

# کشتن process قبلی (اگر وجود داره)
pkill -f "python.*server.py" || true
sleep 1

# اجرای Backend
echo -e "${YELLOW}→ شروع Backend server...${NC}"
nohup python server.py > logs/backend.log 2>&1 &
BACKEND_PID=$!

sleep 3

# چک کردن Backend
if ps -p $BACKEND_PID > /dev/null; then
    echo -e "${GREEN}✓ Backend در حال اجرا است (PID: $BACKEND_PID)${NC}"
else
    echo -e "${RED}✗ Backend شروع نشد! لاگ را چک کنید:${NC}"
    echo -e "${RED}  tail -f backend/logs/backend.log${NC}"
    exit 1
fi

################################################################################
# 3. راه‌اندازی Frontend
################################################################################
echo ""
echo -e "${YELLOW}[3/5] راه‌اندازی Frontend...${NC}"

cd "$PROJECT_DIR/frontend"

# نصب وابستگی‌ها (اگر node_modules وجود نداره)
if [ ! -d "node_modules" ]; then
    echo -e "${YELLOW}→ نصب وابستگی‌های Node...${NC}"
    yarn install --silent
fi

# کشتن process قبلی
pkill -f "craco start" || true
pkill -f "react-scripts start" || true
sleep 1

# اجرای Frontend
echo -e "${YELLOW}→ شروع Frontend server...${NC}"
nohup yarn start > ../backend/logs/frontend.log 2>&1 &
FRONTEND_PID=$!

sleep 5

# چک کردن Frontend
if ps -p $FRONTEND_PID > /dev/null; then
    echo -e "${GREEN}✓ Frontend در حال اجرا است (PID: $FRONTEND_PID)${NC}"
else
    echo -e "${RED}✗ Frontend شروع نشد! لاگ را چک کنید:${NC}"
    echo -e "${RED}  tail -f backend/logs/frontend.log${NC}"
    exit 1
fi

################################################################################
# 4. ایجاد Admin (اگر وجود نداره)
################################################################################
echo ""
echo -e "${YELLOW}[4/5] بررسی کاربر Admin...${NC}"

sleep 3

# صدا زدن API برای ایجاد Admin
RESPONSE=$(curl -s -X POST http://localhost:8001/api/setup/init 2>/dev/null || echo "error")

if echo "$RESPONSE" | grep -q "created\|exists"; then
    echo -e "${GREEN}✓ کاربر Admin آماده است${NC}"
else
    echo -e "${YELLOW}⚠ نمی‌توانم Admin را ایجاد کنم. بعداً دستی ایجاد کنید:${NC}"
    echo -e "${YELLOW}  curl -X POST http://localhost:8001/api/setup/init${NC}"
fi

################################################################################
# 5. نمایش اطلاعات
################################################################################
echo ""
echo -e "${BLUE}════════════════════════════════════════════════════════════${NC}"
echo -e "${GREEN}✓ سیستم با موفقیت راه‌اندازی شد!${NC}"
echo -e "${BLUE}════════════════════════════════════════════════════════════${NC}"
echo ""
echo -e "${BOLD}📍 آدرس‌های دسترسی:${NC}"
echo -e "   Frontend:  ${GREEN}http://localhost:3000${NC}"
echo -e "   Backend:   ${GREEN}http://localhost:8001${NC}"
echo -e "   API Docs:  ${GREEN}http://localhost:8001/docs${NC}"
echo ""
echo -e "${BOLD}👤 اطلاعات ورود Admin:${NC}"
echo -e "   Email:     ${GREEN}admin@mlm.com${NC}"
echo -e "   Password:  ${GREEN}admin123${NC}"
echo ""
echo -e "${BOLD}📝 لاگ‌ها:${NC}"
echo -e "   Backend:   ${YELLOW}tail -f backend/logs/backend.log${NC}"
echo -e "   Frontend:  ${YELLOW}tail -f backend/logs/frontend.log${NC}"
echo ""
echo -e "${BOLD}🛑 برای متوقف کردن:${NC}"
echo -e "   ${YELLOW}./stop.sh${NC}"
echo ""
echo -e "${BLUE}════════════════════════════════════════════════════════════${NC}"
echo ""

# ذخیره PIDs
echo "$BACKEND_PID" > backend/logs/backend.pid
echo "$FRONTEND_PID" > backend/logs/frontend.pid

# پیام انتهایی
echo -e "${GREEN}✓ مرورگر خود را باز کنید و به آدرس بروید:${NC}"
echo -e "${GREEN}  http://localhost:3000/login${NC}"
echo ""
