"""Telegram Models - مدل‌های تلگرام"""

from pydantic import BaseModel, Field
from typing import Optional


class TelegramSettings(BaseModel):
    """تنظیمات ربات تلگرام"""
    enabled: bool = False
    bot_token: Optional[str] = None
    bot_username: Optional[str] = None
    webapp_url: Optional[str] = None
    welcome_message: Optional[str] = None
    activation_message: Optional[str] = None


class TelegramNotificationRequest(BaseModel):
    """درخواست ارسال نوتیفیکیشن تلگرام"""
    user_id: str = Field(description="شناسه کاربر")
    message: str = Field(min_length=1, max_length=4096, description="متن پیام")


class TelegramBroadcast(BaseModel):
    """ارسال پیام عمومی"""
    message: str = Field(min_length=1, max_length=4096, description="متن پیام")
