"""Cached Settings Helper"""
from functools import lru_cache
import asyncio
from datetime import datetime, timedelta

# Simple in-memory cache برای settings
_settings_cache = {}
_cache_timeout = 300  # 5 minutes

async def get_reward_settings_cached(db):
    """دریافت settings با cache"""
    now = datetime.now()
    
    if "rewards" in _settings_cache:
        cached_time, data = _settings_cache["rewards"]
        if (now - cached_time).seconds < _cache_timeout:
            return data
    
    # Fetch از DB
    settings = await db.settings.find_one({"setting_id": "rewards"})
    _settings_cache["rewards"] = (now, settings)
    
    return settings

def clear_settings_cache():
    """پاک کردن cache"""
    _settings_cache.clear()
