"""Admin Models - مدل‌های مدیریتی"""

from pydantic import BaseModel, Field
from typing import Optional


class TestUserCreate(BaseModel):
    """ایجاد کاربران تستی"""
    count: int = Field(default=1, gt=0, le=1000, description="تعداد کاربران")
    auto_activate: bool = Field(default=True, description="فعال‌سازی خودکار")
    referral_code: Optional[str] = Field(default=None, description="کد معرف")


class FillTreeData(BaseModel):
    """پر کردن درخت کاربر"""
    user_id: str = Field(description="شناسه کاربر")
    levels: int = Field(default=3, gt=0, le=10, description="تعداد سطوح")


class PointsAdjustment(BaseModel):
    """تنظیم امتیاز کاربر"""
    amount: float = Field(description="مبلغ تغییر (مثبت یا منفی)")
    reason: str = Field(min_length=1, max_length=500, description="دلیل تغییر")


class ConfigUpdate(BaseModel):
    """بروزرسانی تنظیمات"""
    key: str = Field(min_length=1, max_length=100)
    value: str = Field(max_length=10000)


class HotWalletCreate(BaseModel):
    """ایجاد کیف پول هات"""
    network: str = Field(description="شبکه - TRON یا BSC")
    address: str = Field(min_length=10, description="آدرس کیف پول")
    private_key: str = Field(min_length=10, description="کلید خصوصی")


class TestTransferRequest(BaseModel):
    """تست انتقال"""
    network: str = Field(description="شبکه")
    to_address: str = Field(description="آدرس مقصد")
    amount: float = Field(gt=0, description="مبلغ")
