# 🚀 راهنمای راه‌اندازی سیستم MLM

## ❌ مشکل: وارد سیستم نمیشه

### علت اصلی:
فایل‌های `.env` برای Frontend و Backend وجود نداشت!

---

## ✅ راه‌حل (مرحله به مرحله):

### 1️⃣ نصب MongoDB (اگر نصب نیست):

#### روش 1: Docker (توصیه می‌شه):
```bash
# نصب Docker
curl -fsSL https://get.docker.com -o get-docker.sh
sudo sh get-docker.sh

# اجرای MongoDB
docker run -d \
  --name mlm-mongodb \
  -p 27017:27017 \
  -v mongodb_data:/data/db \
  mongo:latest

# بررسی
docker ps | grep mongo
```

#### روش 2: نصب مستقیم (Ubuntu/Debian):
```bash
# نصب MongoDB
sudo apt-get update
sudo apt-get install -y mongodb

# شروع سرویس
sudo systemctl start mongodb
sudo systemctl enable mongodb

# بررسی
sudo systemctl status mongodb
```

---

### 2️⃣ راه‌اندازی Backend:

```bash
# رفتن به پوشه backend
cd /home/claude/amozeshi_final/backend

# نصب وابستگی‌ها
pip3 install -r requirements.txt --break-system-packages

# اجرای سرور (روش 1 - پیشنهادی):
python3 server.py

# یا اجرای سرور (روش 2 - با uvicorn):
uvicorn server:app --host 0.0.0.0 --port 8001 --reload
```

**⚠️ توجه:** سرور باید روی پورت **8001** اجرا شه!

---

### 3️⃣ راه‌اندازی Frontend:

```bash
# رفتن به پوشه frontend
cd /home/claude/amozeshi_final/frontend

# نصب وابستگی‌ها (اولین بار):
yarn install

# اجرای frontend
yarn start
```

**✅ Frontend روی پورت 3000 اجرا میشه.**

---

### 4️⃣ ایجاد کاربر Admin (اولین بار):

#### روش 1: از طریق API:
```bash
curl -X POST http://localhost:8001/api/setup/init
```

**اطلاعات ورود Admin:**
- **Email:** `admin@mlm.com`
- **Password:** `admin123`

#### روش 2: مستقیم در MongoDB:
```bash
# اتصال به MongoDB
mongo mlm_database

# ایجاد admin
db.users.insertOne({
  "user_id": "seed",
  "email": "admin@mlm.com",
  "password": "$2b$12$XNYj3qWN7qk9wV5fXvLZP.VQ6pJ4V8uBz8YN6T5Jz1fN9Q7X8Y9Z0",
  "role": "admin",
  "status": "active",
  "placement_path": "seed",
  "depth": 0,
  "total_points": 0,
  "created_at": new Date().toISOString()
})
```

---

### 5️⃣ بررسی سیستم:

#### ✅ چک کردن Backend:
```bash
# Health check
curl http://localhost:8001/api/health

# باید پاسخ دهد:
# {"status": "healthy"}
```

#### ✅ چک کردن MongoDB:
```bash
# لیست دیتابیس‌ها
mongo --eval "show dbs"

# تعداد کاربران
mongo mlm_database --eval "db.users.count()"
```

#### ✅ چک کردن Frontend:
1. باز کردن مرورگر: `http://localhost:3000`
2. باید صفحه Login نمایش داده شه

---

### 6️⃣ ورود به سیستم:

1. باز کنید: `http://localhost:3000/login`
2. وارد کنید:
   - **Email:** `admin@mlm.com`
   - **Password:** `admin123`
3. دکمه "ورود" رو بزنید

**✅ باید وارد داشبورد Admin بشید!**

---

## 🔧 عیب‌یابی (Troubleshooting):

### ❌ خطا: "Network Error"
**علت:** Backend اجرا نشده
**راه‌حل:**
```bash
cd backend
python3 server.py
```

### ❌ خطا: "Failed to connect to MongoDB"
**علت:** MongoDB اجرا نیست
**راه‌حل:**
```bash
# Docker:
docker start mlm-mongodb

# یا نصب مستقیم:
sudo systemctl start mongodb
```

### ❌ خطا: "CORS Error"
**علت:** CORS غلط تنظیم شده
**راه‌حل:** در `backend/.env` چک کنید:
```
CORS_ORIGINS=http://localhost:3000,http://127.0.0.1:3000
```

### ❌ خطا: "Cannot find module"
**علت:** وابستگی‌ها نصب نشدن
**راه‌حل:**
```bash
# Backend:
cd backend
pip3 install -r requirements.txt --break-system-packages

# Frontend:
cd frontend
yarn install
```

### ❌ خطا: "Port already in use"
**علت:** پورت قبلاً استفاده شده
**راه‌حل:**
```bash
# پیدا کردن process روی پورت 8001:
sudo lsof -i :8001

# کشتن process:
sudo kill -9 <PID>

# یا تغییر پورت در .env:
PORT=8002
```

---

## 📝 نکات مهم:

### ✅ تنظیمات Production:
1. در `backend/.env` حتماً `JWT_SECRET` رو تغییر بدید
2. `MONGO_URL` رو به آدرس واقعی MongoDB تغییر بدید
3. `CORS_ORIGINS` رو به دامنه واقعی سایت تغییر بدید

### ✅ امنیت:
- **هرگز** فایل `.env` رو در Git commit نکنید!
- فایل `.gitignore` وجود داره که `.env` رو ignore می‌کنه

### ✅ لاگ‌ها:
```bash
# لاگ‌های Backend:
tail -f backend/logs/mlm_system.log

# لاگ‌های MongoDB:
docker logs mlm-mongodb -f
```

---

## 🎉 موفق!

اگر تمام مراحل رو دنبال کردید، سیستم باید کامل کار کنه!

**تست نهایی:**
1. ✅ Backend روی `http://localhost:8001` در حال اجرا
2. ✅ Frontend روی `http://localhost:3000` در حال اجرا
3. ✅ MongoDB در حال اجرا
4. ✅ Admin user ایجاد شده
5. ✅ میتونید لاگین کنید

---

## 📞 پشتیبانی:

اگر باز هم مشکلی داشتید، این اطلاعات رو بفرستید:
1. لاگ Backend: `backend/logs/mlm_system.log`
2. خروجی Console در مرورگر (F12 > Console)
3. نسخه Python: `python3 --version`
4. نسخه Node: `node --version`
5. نسخه MongoDB: `mongo --version`
