# 🔒 راهنمای کامل فعال‌سازی SSL/HTTPS

## 📋 فهرست مطالب
1. [پیش‌نیازها](#پیش-نیازها)
2. [مراحل نصب](#مراحل-نصب)
3. [تست و بررسی](#تست-و-بررسی)
4. [تمدید خودکار](#تمدید-خودکار)
5. [عیب‌یابی](#عیب-یابی)
6. [پشتیبان‌گیری](#پشتیبان-گیری)

---

## ✅ پیش‌نیازها

### 1. دامنه (Domain)
- ✅ یک دامنه معتبر داشته باشید
- ✅ DNS دامنه به IP سرور اشاره کند
- ✅ حداقل 1 ساعت برای انتشار DNS صبر کنید

**تست DNS:**
```bash
# از کامپیوتر خودتون اجرا کنید
dig +short yourdomain.com

# باید IP سرورتون رو نشون بده
```

### 2. پورت‌های آزاد
- ✅ پورت 80 (HTTP)
- ✅ پورت 443 (HTTPS)

**چک کردن پورت‌ها:**
```bash
# باید خالی باشن یا nginx/docker استفاده کنن
sudo netstat -tlnp | grep ":80 "
sudo netstat -tlnp | grep ":443 "
```

### 3. سیستم نصب شده
- ✅ سیستم MLM با docker-deploy.sh نصب شده
- ✅ همه containers در حال اجرا هستند

**چک کردن:**
```bash
sudo docker compose ps
# همه باید "Up" باشند
```

---

## 🚀 مراحل نصب

### مرحله 1: آماده‌سازی

```bash
cd /path/to/mlm_system

# اطمینان از نصب PyYAML برای اسکریپت
sudo apt install -y python3-yaml

# اختصاص مجوز اجرا
chmod +x enable-ssl.sh
chmod +x check-ssl.sh
```

### مرحله 2: اجرای اسکریپت SSL

```bash
sudo ./enable-ssl.sh
```

**سوالاتی که پرسیده می‌شود:**

1. **آیا DNS تنظیم شده است؟**
   ```
   آیا دامنه شما به این سرور اشاره می‌کند؟ (y/n): y
   ```

2. **دامنه:**
   ```
   دامنه خود را وارد کنید (مثال: mlm.example.com): yourdomain.com
   ```

3. **ایمیل:**
   ```
   ایمیل خود را وارد کنید (برای اطلاعیه‌های Let's Encrypt): your@email.com
   ```

4. **تایید نهایی:**
   ```
   ادامه می‌دهیم؟ (y/n): y
   ```

### مرحله 3: منتظر بمانید

اسکریپت این کارها رو انجام میده:

1. ✅ نصب Certbot (30 ثانیه)
2. ✅ دریافت گواهی SSL (1-2 دقیقه)
3. ✅ تنظیم Nginx برای HTTPS (30 ثانیه)
4. ✅ به‌روزرسانی Frontend (1-2 دقیقه)
5. ✅ تنظیم تمدید خودکار (30 ثانیه)
6. ✅ راه‌اندازی مجدد سیستم (1 دقیقه)

**⏱ زمان کل: 5-7 دقیقه**

### مرحله 4: تایید موفقیت

بعد از اتمام، این پیام رو می‌بینید:

```
════════════════════════════════════════════════════════════════
          ✅ SSL/HTTPS با موفقیت فعال شد! 🔒
════════════════════════════════════════════════════════════════

🌐 دسترسی:
   HTTPS:  https://yourdomain.com
   HTTP:   http://yourdomain.com  (redirect به HTTPS)

🔐 اطلاعات ورود:
   Email:    admin@mlm.com
   Password: admin123
```

---

## 🧪 تست و بررسی

### تست خودکار

```bash
sudo ./check-ssl.sh
```

این اسکریپت 8 تست انجام میده:
1. ✅ بررسی DNS
2. ✅ بررسی پورت‌ها
3. ✅ بررسی گواهی SSL
4. ✅ تست HTTPS Connection
5. ✅ تست HTTP Redirect
6. ✅ بررسی تمدید خودکار
7. ✅ وضعیت Containers
8. ✅ لاگ‌های Nginx

### تست دستی

```bash
# 1. تست HTTPS
curl -I https://yourdomain.com/health
# باید Status 200 OK برگردونه

# 2. تست Redirect
curl -I http://yourdomain.com
# باید 301 Moved Permanently و Location: https://... برگردونه

# 3. تست در مرورگر
# برو به: https://yourdomain.com
# باید قفل سبز 🔒 رو ببینی
```

### چک کردن گواهی

```bash
# اطلاعات کامل گواهی
sudo certbot certificates

# تاریخ انقضا
sudo openssl x509 -enddate -noout -in /etc/letsencrypt/live/yourdomain.com/fullchain.pem
```

---

## 🔄 تمدید خودکار

### چگونه کار می‌کند؟

1. **Certbot Timer:**
   - هر 12 ساعت یکبار فعال می‌شود
   - چک می‌کنه گواهی کمتر از 30 روز اعتبار داره؟
   - اگه بله → خودکار تمدید می‌کنه

2. **Renewal Hook:**
   - بعد از تمدید، Nginx رو reload می‌کنه
   - بدون downtime

3. **ایمیل‌های هشدار:**
   - 20 روز قبل از انقضا
   - 10 روز قبل از انقضا
   - 1 روز قبل از انقضا

### چک کردن وضعیت Timer

```bash
# وضعیت Timer
sudo systemctl status certbot.timer

# آخرین و بعدی اجرا
sudo systemctl list-timers certbot.timer

# لاگ‌های تمدید
sudo journalctl -u certbot.timer
```

### تست تمدید

```bash
# تست بدون تمدید واقعی (dry-run)
sudo certbot renew --dry-run

# اگه این پیام رو دیدی، تمدید خودکار کار می‌کنه:
# "Congratulations, all simulated renewals succeeded"
```

### تمدید دستی (اگه نیاز شد)

```bash
# تمدید تمام گواهی‌ها
sudo certbot renew

# تمدید یک دامنه خاص
sudo certbot renew --cert-name yourdomain.com

# بعد از تمدید دستی:
sudo docker compose exec nginx nginx -s reload
```

---

## 🐛 عیب‌یابی

### مشکل 1: DNS به سرور اشاره نمی‌کند

**علائم:**
```
❌ DNS به این سرور اشاره ندارد!
DNS IP:    1.2.3.4
Server IP: 5.6.7.8
```

**راه‌حل:**
1. به پنل دامنه خود بروید
2. یک رکورد A اضافه/ویرایش کنید:
   ```
   Type: A
   Name: @ (یا subdomain)
   Value: 5.6.7.8 (IP سرور)
   TTL: 3600
   ```
3. 1-2 ساعت صبر کنید
4. تست کنید: `dig +short yourdomain.com`

### مشکل 2: پورت 443 اشغال است

**علائم:**
```
Problem binding to port 443: Could not bind to IPv4 or IPv6
```

**راه‌حل:**
```bash
# پیدا کردن برنامه‌ای که پورت رو اشغال کرده
sudo netstat -tlnp | grep :443

# اگه Apache یا Nginx قدیمی بود:
sudo systemctl stop apache2
sudo systemctl stop nginx
sudo systemctl disable apache2
sudo systemctl disable nginx

# اجرای مجدد
sudo ./enable-ssl.sh
```

### مشکل 3: Certificate Verification Failed

**علائم:**
```
Failed authorization procedure. yourdomain.com (http-01): 
urn:ietf:params:acme:error:connection
```

**دلایل احتمالی:**
1. DNS هنوز منتشر نشده (صبر کنید)
2. Firewall پورت 80 رو بسته (باز کنید)
3. Cloudflare فعال هست (موقتاً غیرفعال کنید)

**راه‌حل:**
```bash
# چک کردن Firewall
sudo ufw status
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp

# تست دسترسی از خارج
curl -I http://yourdomain.com
```

### مشکل 4: Mixed Content Errors

**علائم:**
در Console مرورگر:
```
Mixed Content: The page at 'https://...' was loaded over HTTPS, 
but requested an insecure resource 'http://...'
```

**راه‌حل:**
```bash
# Frontend .env رو چک کنید
cat frontend/.env

# باید https باشه:
REACT_APP_BACKEND_URL=https://yourdomain.com
REACT_APP_API_URL=https://yourdomain.com/api

# اگه http بود، تغییرش بدید و rebuild کنید:
cd frontend
docker build -t mlm-frontend .
cd ..
sudo docker compose restart frontend
```

### مشکل 5: Nginx 502 Bad Gateway

**علائم:**
```
502 Bad Gateway
nginx/1.25.3
```

**راه‌حل:**
```bash
# چک کردن Backend
sudo docker compose ps backend
sudo docker compose logs backend

# اگه Down بود:
sudo docker compose restart backend

# اگه Error داشت:
sudo docker compose logs backend --tail 100
```

### مشکل 6: تمدید خودکار کار نمی‌کند

**علائم:**
ایمیل دریافت کردید:
```
Your certificate (or certificates) for yourdomain.com will expire in 10 days
```

**راه‌حل:**
```bash
# 1. چک کردن Timer
sudo systemctl status certbot.timer

# اگه inactive بود:
sudo systemctl enable certbot.timer
sudo systemctl start certbot.timer

# 2. تست تمدید
sudo certbot renew --dry-run

# 3. اگه خطا داد، تمدید دستی:
sudo docker compose stop nginx
sudo certbot renew
sudo docker compose start nginx
```

---

## 💾 پشتیبان‌گیری

### فایل‌های Backup خودکار

اسکریپت `enable-ssl.sh` خودکار از این فایل‌ها backup میگیره:

```bash
# لیست backup ها
ls -lh *.backup.*

# بازگردانی nginx.conf
cp nginx.conf.backup.20250107_123456 nginx.conf
sudo docker compose restart nginx

# بازگردانی docker-compose.yml
cp docker-compose.yml.backup.20250107_123456 docker-compose.yml
sudo docker compose up -d

# بازگردانی frontend .env
cp frontend/.env.backup.20250107_123456 frontend/.env
cd frontend && docker build -t mlm-frontend . && cd ..
sudo docker compose restart frontend
```

### Backup دستی

```bash
# Backup کامل گواهی‌ها
sudo tar -czf ssl-backup-$(date +%Y%m%d).tar.gz \
    /etc/letsencrypt \
    nginx.conf \
    docker-compose.yml \
    frontend/.env

# بازیابی
sudo tar -xzf ssl-backup-20250107.tar.gz -C /
sudo docker compose restart nginx
```

---

## 📊 مانیتورینگ و لاگ‌ها

### مشاهده لاگ‌های Nginx

```bash
# Real-time logs
sudo docker compose logs -f nginx

# آخرین 100 خط
sudo docker compose logs nginx --tail 100

# فقط خطاها
sudo docker compose logs nginx | grep -i error
```

### مانیتور تمدید

```bash
# لاگ‌های certbot
sudo journalctl -u certbot.timer -f

# تاریخ تمدید بعدی
sudo certbot certificates | grep "Expiry Date"
```

### SSL Quality Check

```bash
# با OpenSSL
openssl s_client -connect yourdomain.com:443 -servername yourdomain.com

# یا استفاده از SSL Labs:
# https://www.ssllabs.com/ssltest/analyze.html?d=yourdomain.com
```

---

## ✅ Checklist نهایی

بعد از نصب SSL، این موارد رو چک کنید:

- [ ] `https://yourdomain.com` باز می‌شه
- [ ] قفل سبز 🔒 در مرورگر نمایش داده می‌شه
- [ ] `http://yourdomain.com` به HTTPS redirect میشه
- [ ] Login کار می‌کنه
- [ ] ربات تلگرام متصل هست
- [ ] Certbot timer فعال هست: `sudo systemctl status certbot.timer`
- [ ] تست تمدید موفق: `sudo certbot renew --dry-run`
- [ ] Backup ها گرفته شده: `ls *.backup.*`
- [ ] اطلاعات در `SSL_INFO.txt` ذخیره شده

---

## 📞 در صورت مشکل

### اسکریپت‌های کمکی

```bash
# چک کامل SSL
sudo ./check-ssl.sh

# مشاهده اطلاعات SSL
cat SSL_INFO.txt

# بازگشت به HTTP (اگه لازم شد)
cp nginx.conf.backup.* nginx.conf
sudo docker compose restart nginx
```

### دستورات Emergency

```bash
# Reset کامل SSL
sudo certbot delete --cert-name yourdomain.com
sudo ./enable-ssl.sh

# Restart کامل سیستم
sudo docker compose down
sudo docker compose up -d --build

# بررسی همه چیز
sudo docker compose ps
sudo docker compose logs
```

---

## 🎓 نکات امنیتی

1. **رمز Admin را تغییر دهید:**
   ```
   پیش‌فرض: admin@mlm.com / admin123
   حتماً بعد اولین ورود تغییر دهید!
   ```

2. **Firewall را فعال کنید:**
   ```bash
   sudo ufw enable
   sudo ufw allow 80/tcp
   sudo ufw allow 443/tcp
   sudo ufw allow 22/tcp  # SSH
   ```

3. **Backup منظم:**
   ```bash
   # هر هفته backup بگیرید
   sudo tar -czf backup-$(date +%Y%m%d).tar.gz \
       /etc/letsencrypt \
       ~/mlm_system
   ```

4. **مانیتور لاگ‌ها:**
   ```bash
   # هر روز چک کنید
   sudo docker compose logs --tail 50
   ```

---

## 🎉 تبریک!

سیستم MLM شما حالا با HTTPS امن و با تمدید خودکار آماده است! 🔒✨

اگه سوالی داشتید، فایل `check-ssl.sh` رو اجرا کنید تا همه چیز رو چک کنه.
