import React from 'react';

class ErrorBoundary extends React.Component {
  constructor(props) {
    super(props);
    this.state = { hasError: false };
  }

  static getDerivedStateFromError(error) {
    return { hasError: false }; // همیشه false برگردان تا error overlay نشان داده نشود
  }

  componentDidCatch(error, errorInfo) {
    // فقط log کن، نمایش نده
    console.log('Error caught but suppressed:', error.message);
  }

  render() {
    return this.props.children;
  }
}

export default ErrorBoundary;
