"""Payment Models - مدل‌های پرداخت"""

from pydantic import BaseModel, Field
from typing import Optional


class Payment(BaseModel):
    """مدل پرداخت ساده"""
    payment_id: str
    user_id: str
    amount: float
    timestamp: str
    description: str


class CryptoPaymentCreate(BaseModel):
    """مدل ایجاد پرداخت کریپتو"""
    network: str = "TRON"  # TRON or BSC


class CryptoPaymentVerify(BaseModel):
    """مدل تایید پرداخت کریپتو"""
    payment_id: str
    tx_hash: str


class CryptoPayment(BaseModel):
    """مدل پرداخت کریپتو"""
    payment_id: str
    user_id: str
    amount: float
    unique_amount: float  # مبلغ منحصر به فرد
    network: str  # TRON or BSC
    wallet_address: str  # آدرس کیف پول مقصد
    status: str = "pending"  # pending, confirmed, expired
    tx_hash: Optional[str] = None
    created_at: str
    confirmed_at: Optional[str] = None
    expires_at: str


class CryptoSettings(BaseModel):
    """تنظیمات کریپتو"""
    # TRON Settings
    tron_enabled: bool = True
    tron_wallet_address: str = ""
    tron_api_key: Optional[str] = ""
    tron_private_key: Optional[str] = ""
    
    # BSC Settings  
    bsc_enabled: bool = False
    bsc_wallet_address: str = ""
    bsc_api_key: Optional[str] = ""
    bsc_private_key: Optional[str] = ""
    
    # Withdrawal Settings
    min_withdrawal_amount: float = 10.0
    withdrawal_fee_type: str = "fixed"  # fixed or percentage
    withdrawal_fee_amount: float = 0.0
    
    # Auto Transfer Settings
    auto_transfer_enabled: bool = False
    auto_transfer_threshold: float = 100.0
    auto_transfer_destination: Optional[str] = None
